/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.tools.net;

import de.p2tools.p2lib.tools.log.P2Log;
import java.net.Authenticator;
import java.net.PasswordAuthentication;

public class P2ProxyAuthentication {
    private static final String HTTP_PROXY_USER = "http.proxyUser";
    private static final String HTTP_PROXY_PW = "http.proxyPassword";
    private static final String LOG_TEXT_PROXY_AUTHENTICATION_SUCCESSFUL = "Proxy Authentication: (%s)";
    private static final String LOG_TEXT_PROXY_AUTHENTICATION_NOT_CONFIGURED = "Proxy Authentication: not configured";
    private static final String LOG_TEXT_PROXY_PASSWORD_NOT_SET = "Proxy Authentication: Password is not set";
    private static final String LOG_TEXT_PROXY_AUTHENTICATION_CANNOT_ACCESS_PROXY_USER_PROXY_PW = "Proxy Authentication: cannot access proxyUser / proxyPassword";

    public static void setProxyAuthentication() {
        try {
            String prxUser = System.getProperty(HTTP_PROXY_USER, null);
            String prxPassword = System.getProperty(HTTP_PROXY_PW, null);
            if (prxUser != null && prxPassword != null) {
                final PasswordAuthentication authenticator = new PasswordAuthentication(prxUser, prxPassword.toCharArray());
                Authenticator.setDefault(new Authenticator(){

                    @Override
                    protected PasswordAuthentication getPasswordAuthentication() {
                        return authenticator;
                    }
                });
                P2Log.sysLog(String.format(LOG_TEXT_PROXY_AUTHENTICATION_SUCCESSFUL, prxUser));
            } else if (prxUser != null && prxPassword == null) {
                P2Log.sysLog(LOG_TEXT_PROXY_PASSWORD_NOT_SET);
            } else {
                P2Log.sysLog(LOG_TEXT_PROXY_AUTHENTICATION_NOT_CONFIGURED);
            }
        }
        catch (SecurityException se) {
            P2Log.sysLog(LOG_TEXT_PROXY_AUTHENTICATION_CANNOT_ACCESS_PROXY_USER_PROXY_PW + se.toString());
        }
    }
}

