/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.tools.date;

import de.p2tools.p2lib.tools.date.P2LDateTimeFactory;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.SimpleTimeZone;

public class P2DateGmtFactory {
    private P2DateGmtFactory() {
    }

    public static String getDateTimeGmt() {
        SimpleDateFormat gmtDateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        gmtDateFormat.setTimeZone(new SimpleTimeZone(2, "UTC"));
        return gmtDateFormat.format(new Date());
    }

    public static String getLocalDateTimeStringFromGmt(String strDate) {
        LocalDateTime localDateTime = P2DateGmtFactory.getLocalDateTimeFromGmt(strDate);
        return P2LDateTimeFactory.toString(localDateTime);
    }

    public static LocalDateTime getLocalDateTimeFromGmt(String strDate) {
        if (strDate == null || strDate.isEmpty()) {
            return LocalDateTime.now();
        }
        try {
            SimpleDateFormat sdfUtc = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
            sdfUtc.setTimeZone(new SimpleTimeZone(2, "UTC"));
            Date filmDate = null;
            try {
                filmDate = sdfUtc.parse(strDate);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if (filmDate == null) {
                return LocalDateTime.now();
            }
            return filmDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
        }
        catch (Exception ex) {
            return LocalDateTime.now();
        }
    }
}

