/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.tools;

import de.p2tools.p2lib.tools.log.P2Log;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class P2StringUtils {
    private static final NumberFormat numberFormat = NumberFormat.getNumberInstance(Locale.GERMANY);

    private P2StringUtils() {
    }

    public static String getFormattedString(int number) {
        return numberFormat.format(number);
    }

    public static String convertToASCIIEncoding(String string) {
        String ret = string;
        ret = ret.replace("\u00e4", "ae");
        ret = ret.replace("\u00f6", "oe");
        ret = ret.replace("\u00fc", "ue");
        ret = ret.replace("\u00c4", "Ae");
        ret = ret.replace("\u00d6", "Oe");
        ret = ret.replace("\u00dc", "Ue");
        ret = ret.replace("\u00df", "ss");
        try {
            CharsetEncoder charsetEncoder = Charset.forName("US-ASCII").newEncoder();
            charsetEncoder.onMalformedInput(CodingErrorAction.REPLACE);
            charsetEncoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
            charsetEncoder.replaceWith(new byte[]{95});
            ByteBuffer buf = charsetEncoder.encode(CharBuffer.wrap(ret));
            if (buf.hasArray()) {
                ret = new String(buf.array());
            }
            ret = ret.replaceAll("\\u0000", "");
        }
        catch (CharacterCodingException ex) {
            P2Log.errorLog(945120201, ex);
        }
        return ret;
    }

    public static List<String> removeEmptyStrings(List<String> list) {
        if (list == null || list.size() == 0) {
            return list;
        }
        ListIterator<String> it = list.listIterator();
        while (it.hasNext()) {
            String str = (String)it.next();
            if (str != null && !str.isEmpty()) continue;
            it.remove();
        }
        return list;
    }

    public static String appendList(List<String> list, String separator) {
        return P2StringUtils.appendList(list, separator, false, false);
    }

    public static String appendList(List<String> list, String separator, boolean removeEmpty, boolean removeDouble) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        return P2StringUtils.appendStream(list.stream(), separator, removeEmpty, removeDouble);
    }

    public static String appendArray(String[] list, String separator) {
        return P2StringUtils.appendArray(list, separator, false, false);
    }

    public static String appendArray(String[] list, String separator, boolean removeEmpty, boolean removeDouble) {
        if (list == null || list.length == 0) {
            return "";
        }
        Stream<String> stream = Stream.of(list);
        return P2StringUtils.appendStream(stream, separator, removeEmpty, removeDouble);
    }

    private static String appendStream(Stream<String> stream, String separator, boolean removeEmpty, boolean removeDouble) {
        HashSet set = removeDouble ? new HashSet() : null;
        return stream.filter(s -> s != null).filter(s -> !removeEmpty || !s.isEmpty()).filter(s -> !removeDouble || set.add(s)).collect(Collectors.joining(separator));
    }

    public static void appendString(ArrayList<String> list, String prefix) {
        P2StringUtils.appendString(list, prefix, "");
    }

    public static void appendString(ArrayList<String> list, String prefix, String without) {
        if (list == null || list.size() == 0) {
            return;
        }
        ListIterator<String> it = list.listIterator();
        while (it.hasNext()) {
            String next = it.next();
            if (next == null) {
                it.remove();
                continue;
            }
            if (!without.isEmpty() && next.startsWith(without)) continue;
            it.set(prefix + next);
        }
    }

    public static String shortenString(int max, String text, boolean center, boolean addInFront) {
        if (((String)text).length() > max) {
            text = center && max > 32 ? ((String)text).substring(0, 25) + " .... " + ((String)text).substring(((String)text).length() - (max - 31)) : ((String)text).substring(0, max - 1);
        }
        while (((String)text).length() < max) {
            if (addInFront) {
                text = " " + (String)text;
                continue;
            }
            text = (String)text + " ";
        }
        return text;
    }

    public static String increaseString(int max, String text) {
        return P2StringUtils.increaseString(max, false, text);
    }

    public static String increaseString(int max, boolean front, String text) {
        while (((String)text).length() < max) {
            if (front) {
                text = " " + (String)text;
                continue;
            }
            text = (String)text + " ";
        }
        return text;
    }
}

