/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.tools;

import de.p2tools.p2lib.tools.log.P2Log;

public class P2ShutDown {
    public static final String SHUT_DOWN_LINUX = "shutdown -h now";
    public static final String SHUT_DOWN_WINDOWS = "shutdown.exe -s -t 0";

    public static String getShutDownCommand() {
        String osName = System.getProperty("os.name");
        String shutdownCommand = "";
        if (osName.startsWith("Win")) {
            shutdownCommand = SHUT_DOWN_WINDOWS;
        } else if (osName.startsWith("Linux") || osName.startsWith("Mac")) {
            shutdownCommand = SHUT_DOWN_LINUX;
        } else {
            System.err.println("Shutdown unsupported operating system ...");
        }
        return shutdownCommand;
    }

    public static void shutDown(String shutDown) {
        if (shutDown == null || shutDown.isEmpty()) {
            P2ShutDown.shutDown();
        } else {
            try {
                Runtime.getRuntime().exec(shutDown);
            }
            catch (Exception ex) {
                P2Log.errorLog(953696974, ex.getMessage());
            }
        }
    }

    public static void shutDown() {
        String shutdownCommand = P2ShutDown.getShutDownCommand();
        if (!shutdownCommand.isEmpty()) {
            try {
                Runtime.getRuntime().exec(shutdownCommand);
            }
            catch (Exception ex) {
                P2Log.errorLog(457892014, ex.getMessage());
            }
        }
    }
}

