/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.mediathek.download;

import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.tools.log.P2Log;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.concurrent.TimeUnit;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;

public class MtHttpClientProxy {
    private static final MtHttpClientProxy ourInstance = new MtHttpClientProxy();
    private static final String HTTP_PROXY_AUTHORIZATION = "Proxy-Authorization";
    private OkHttpClient httpClient;
    private OkHttpClient copyClient;

    private MtHttpClientProxy() {
        String proxyHost = P2LibConst.proxyHost.getValueSafe();
        String proxyPort = P2LibConst.proxyPort.getValueSafe();
        try {
            if (!P2LibConst.useProxy.getValue().booleanValue()) {
                this.setupNonProxyClients();
                P2Log.debugLog("Keinen Proxy setzen");
            } else if (!proxyHost.isEmpty() && !proxyPort.isEmpty()) {
                Proxy proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, Integer.parseInt(proxyPort)));
                this.setupProxyClients(proxy);
                P2Log.debugLog("Proxy verwenden: :\n" + proxyHost + " - " + proxyPort);
            } else {
                this.setupNonProxyClients();
                P2Log.debugLog("Keinen Proxy setzen, Vorgaben nicht vollst\u00e4ndig:\n" + proxyHost + " - " + proxyPort);
            }
        }
        catch (NumberFormatException ex) {
            this.setupNonProxyClients();
            P2Log.debugLog("Keinen Proxy setzen, Fehler:\n" + proxyHost + " - " + proxyPort);
        }
    }

    private void setupProxyClients(Proxy proxy) {
        Authenticator proxyAuthenticator = this.setupProxyAuthenticator();
        OkHttpClient.Builder tmpBuilder = this.getDefaultClientBuilder().proxy(proxy);
        if (proxyAuthenticator != null) {
            tmpBuilder.proxyAuthenticator(proxyAuthenticator);
        }
        this.httpClient = tmpBuilder.build();
        tmpBuilder = this.getDefaultClientBuilder().connectTimeout(5L, TimeUnit.SECONDS).readTimeout(5L, TimeUnit.SECONDS).writeTimeout(2L, TimeUnit.SECONDS).proxy(proxy);
        if (proxyAuthenticator != null) {
            tmpBuilder.proxyAuthenticator(proxyAuthenticator);
        }
        this.copyClient = tmpBuilder.build();
    }

    private void setupNonProxyClients() {
        this.httpClient = this.getDefaultClientBuilder().build();
        this.copyClient = this.getDefaultClientBuilder().connectTimeout(5L, TimeUnit.SECONDS).readTimeout(5L, TimeUnit.SECONDS).writeTimeout(2L, TimeUnit.SECONDS).build();
    }

    private Authenticator setupProxyAuthenticator() {
        String prxUser = P2LibConst.proxyUser.getValueSafe();
        String prxPassword = P2LibConst.proxyPwd.getValueSafe();
        Authenticator proxyAuthenticator = null;
        if (!prxUser.isEmpty() && !prxPassword.isEmpty()) {
            proxyAuthenticator = this.createAuthenticator(prxUser, prxPassword);
            P2Log.debugLog("Authenticator setzen");
        }
        return proxyAuthenticator;
    }

    private Authenticator createAuthenticator(String prxUser, String prxPassword) {
        return (route, response) -> {
            if (response.request().header(HTTP_PROXY_AUTHORIZATION) != null) {
                return null;
            }
            String credential = Credentials.basic(prxUser, prxPassword);
            return response.request().newBuilder().header(HTTP_PROXY_AUTHORIZATION, credential).build();
        };
    }

    private OkHttpClient.Builder getDefaultClientBuilder() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.connectTimeout(30L, TimeUnit.SECONDS).writeTimeout(30L, TimeUnit.SECONDS).readTimeout(30L, TimeUnit.SECONDS);
        return builder;
    }

    public static MtHttpClientProxy getInstance() {
        return ourInstance;
    }

    public OkHttpClient getHttpClient() {
        return this.httpClient;
    }

    public OkHttpClient getReducedTimeOutClient() {
        return this.copyClient;
    }
}

