/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.mediathek.download;

import de.p2tools.p2lib.P2ProgIcons;
import de.p2tools.p2lib.dialogs.dialog.P2DialogExtra;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.P2ProgressBar;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class DownloadProgressDialog_
extends P2DialogExtra {
    private final VBox vBoxCont;
    private final Button btnCancel = new Button("");
    private final GridPane gridPane = new GridPane();
    private final P2ProgressBar progressBar = new P2ProgressBar();
    private final Label lblName = new Label();
    private boolean isCanceled = false;
    private String startText = "";

    DownloadProgressDialog_(Stage stage, String fileName, String text) {
        super(stage, null, "Download", false, false, P2DialogExtra.DECO.NO_BORDER);
        this.lblName.setText(fileName);
        this.startText = text;
        this.vBoxCont = this.getVBoxCont();
        this.init(true);
    }

    @Override
    public void make() {
        this.vBoxCont.setPadding(new Insets(5.0));
        this.vBoxCont.setSpacing(10.0);
        this.vBoxCont.getChildren().addAll((Node[])new Node[]{this.gridPane});
        this.progressBar.setMinWidth(100.0);
        this.progressBar.setProgress(0.0, this.startText);
        this.gridPane.setPadding(new Insets(0.0));
        this.gridPane.setHgap(5.0);
        this.gridPane.setVgap(5.0);
        this.gridPane.add(this.lblName, 0, 0, 2, 1);
        this.gridPane.add(this.progressBar, 0, 1);
        this.gridPane.add(this.btnCancel, 1, 1);
        this.gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcComputedSizeAndHgrow(), P2ColumnConstraints.getCcPrefSize()});
        this.btnCancel.setGraphic(P2ProgIcons.IMAGE_STOP.getImageView());
        this.btnCancel.setTooltip(new Tooltip("Den Download abbrechen"));
        this.btnCancel.setOnAction(event -> {
            this.isCanceled = true;
            this.quit();
        });
    }

    public void setProgress(double progress, String text) {
        Platform.runLater(() -> this.progressBar.setProgress(progress, text));
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    private void quit() {
        this.close();
    }

    @Override
    public void close() {
        Platform.runLater(() -> super.close());
    }
}

