/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.mediathek.audiolistload;

import de.p2tools.p2lib.mediathek.audiolistload.P2LoadAudioFactory;
import de.p2tools.p2lib.mediathek.audiolistload.P2ReadLocalAudioList;
import de.p2tools.p2lib.mediathek.audiolistload.P2ReadWebAudioList;
import de.p2tools.p2lib.mediathek.filmdata.FilmData;
import de.p2tools.p2lib.mediathek.filmdata.Filmlist;
import de.p2tools.p2lib.mediathek.filmlistload.P2LoadConst;
import de.p2tools.p2lib.p2event.P2Event;
import de.p2tools.p2lib.p2event.P2EventHandler;
import de.p2tools.p2lib.p2event.P2Events;
import de.p2tools.p2lib.tools.date.P2LDateFactory;
import de.p2tools.p2lib.tools.duration.P2Duration;
import de.p2tools.p2lib.tools.log.P2Log;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;

public class P2LoadAudioList {
    private final P2EventHandler p2EventHandler;
    public final Filmlist<FilmData> audioListNew;

    public P2LoadAudioList(P2EventHandler p2EventHandler, Filmlist<FilmData> audioListNew) {
        this.p2EventHandler = p2EventHandler;
        this.audioListNew = audioListNew;
    }

    public void loadAudioListAtProgStart() {
        new Thread(() -> {
            P2Duration.counterStart("loadAudioListAtProgStart");
            this.p2EventHandler.notifyListener(new P2Event(P2Events.LOAD_AUDIO_LIST_START, "Programmstart, Liste laden", -1.0));
            ArrayList<String> logList = new ArrayList<String>();
            logList.add("## ############################################################");
            logList.add("## ############################################################");
            logList.add("## Audioliste laden");
            logList.add("## Audioliste beim **Programmstart** laden - start");
            logList.add("## ");
            this.loadAudioListAtProgStart(logList);
            this.afterLoading(logList);
            logList.add("## Audioliste beim Programmstart laden - ende");
            logList.add("## ############################################################");
            logList.add("## ############################################################");
            logList.add("");
            P2Log.emptyLine();
            P2Log.sysLog(logList);
            P2Log.emptyLine();
            P2Duration.counterStop("loadAudioListAtProgStart");
        }).start();
    }

    public void loadNewAudioListFromWeb() {
        new Thread(() -> {
            P2Duration.counterStart("loadNewAudioListFromWeb");
            this.p2EventHandler.notifyListener(new P2Event(P2Events.LOAD_AUDIO_LIST_START, "Audioliste aus dem Web laden", -1.0));
            ArrayList<String> logList = new ArrayList<String>();
            logList.add("## ############################################################");
            logList.add("## ############################################################");
            logList.add("## Audioliste laden");
            logList.add("## Audioliste aus dem Web laden - start");
            logList.add("## Alte Liste erstellt  am: " + P2LoadConst.dateStoredAudiolist.getValueSafe());
            logList.add("##            Anzahl Beitr\u00e4ge: " + P2LoadConst.audioListLocal.size());
            logList.add("##");
            P2LoadConst.audioInitNecessary = true;
            new P2ReadWebAudioList(logList, this.audioListNew).readWebList(P2LoadConst.localAudioListFile);
            this.afterLoading(logList);
            logList.add("## Audioliste aus dem Web laden - ende");
            logList.add("## ############################################################");
            logList.add("## ############################################################");
            logList.add("");
            P2Log.emptyLine();
            P2Log.sysLog(logList);
            P2Log.emptyLine();
            P2Duration.counterStop("loadNewAudioListFromWeb");
        }).start();
    }

    private void loadAudioListAtProgStart(List<String> logList) {
        if (P2LoadConst.firstProgramStart) {
            logList.add("## Erster Programmstart -> Liste aus dem Web laden");
            P2LoadConst.audioInitNecessary = true;
            new P2ReadWebAudioList(logList, this.audioListNew).readWebList(P2LoadConst.localAudioListFile);
            P2Duration.onlyPing("Erster Programmstart: Neu Audioliste aus dem Web geladen");
            this.p2EventHandler.notifyListener(new P2Event(P2Events.LOAD_AUDIO_LIST_LOADED, "Audios verarbeiten", -1.0));
            return;
        }
        if (!P2LoadConst.loadNewFilmlistOnProgramStart) {
            logList.add("## Beim Programmstart soll keine neue Liste geladen werden");
            logList.add("## dann gespeicherte Liste laden");
            P2LoadConst.audioInitNecessary = true;
            new P2ReadLocalAudioList(logList, this.audioListNew).readLocalList(P2LoadConst.localAudioListFile);
            logList.add("## Gespeicherte Liste geladen");
            this.p2EventHandler.notifyListener(new P2Event(P2Events.LOAD_AUDIO_LIST_LOADED, "Audios verarbeiten", -1.0));
            return;
        }
        boolean loadFromWeb = false;
        if (P2LoadAudioFactory.isNotFromToday(P2LoadConst.dateStoredAudiolist.getValueSafe())) {
            logList.add("## Gespeicherte Audioliste ist zu alt: " + P2LoadConst.dateStoredAudiolist.getValueSafe());
            logList.add("## Zuerst gespeicherte Liste laden");
            loadFromWeb = true;
            P2LoadConst.audioInitNecessary = false;
            new P2ReadLocalAudioList(logList, this.audioListNew).readLocalList(P2LoadConst.localAudioListFile);
            logList.add("## Programmstart: Gespeicherte Liste geladen");
        } else {
            logList.add("## Gespeicherte Audioliste ist nicht zu alt: " + P2LoadConst.dateStoredAudiolist.getValueSafe());
            logList.add("## Gespeicherte Liste laden");
            P2LoadConst.audioInitNecessary = true;
            new P2ReadLocalAudioList(logList, this.audioListNew).readLocalList(P2LoadConst.localAudioListFile);
            logList.add("## Programmstart: Gespeicherte Liste geladen");
        }
        if (this.audioListNew.isEmpty() || loadFromWeb) {
            logList.add("## ------------------------------------------------------------");
            logList.add("## Gespeicherte Audioliste ist leer oder zu alt -> neue Audioliste aus dem Web laden");
            this.p2EventHandler.notifyListener(new P2Event(P2Events.LOAD_AUDIO_LIST_PROGRESS, "Audioliste ist zu alt, eine neue laden", -1.0));
            P2LoadConst.audioInitNecessary = true;
            new P2ReadWebAudioList(logList, this.audioListNew).readWebList(P2LoadConst.localAudioListFile);
            P2Duration.onlyPing("Programmstart: Neu Audioliste aus dem Web geladen");
        }
        if (this.audioListNew.isEmpty()) {
            logList.add("## Das Laden der Liste hat nicht geklappt");
            logList.add("## Noch ein Versuch: Gespeicherte Liste laden");
            P2LoadConst.audioInitNecessary = true;
            new P2ReadLocalAudioList(logList, this.audioListNew).readLocalList(P2LoadConst.localAudioListFile);
            logList.add("## Gespeicherte Liste geladen");
        }
        this.p2EventHandler.notifyListener(new P2Event(P2Events.LOAD_AUDIO_LIST_LOADED, "Audios verarbeiten", -1.0));
    }

    private void afterLoading(List<String> logList) {
        logList.add("##");
        logList.add("## Jetzige Liste erstellt am: " + P2LDateFactory.getNowString());
        logList.add("##   Anzahl Audios: " + this.audioListNew.size());
        logList.add("##");
        logList.add("## ============================================================");
        logList.add("##");
        this.p2EventHandler.notifyListener(new P2Event(P2Events.LOAD_AUDIO_LIST_LOADED, "Audios markieren, Themen suchen", -1.0));
        logList.add("## ==> und jetzt die Audioliste wieder f\u00fcllen :)");
        Platform.runLater(() -> {
            P2LoadConst.audioListLocal.sender = this.audioListNew.sender;
            P2LoadConst.audioListLocal.metaData = this.audioListNew.metaData;
            P2LoadConst.audioListLocal.setAll(this.audioListNew);
            this.audioListNew.clear();
            this.p2EventHandler.notifyListener(new P2Event(P2Events.LOAD_AUDIO_LIST_FINISHED));
        });
    }
}

