/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.guitools.ptoggleswitch;

import javafx.beans.property.BooleanProperty;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;

public class P2ToggleSwitch
extends HBox {
    private final CheckBox checkBox = new CheckBox();
    private final Label lblLeft = new Label();
    private Label lblRight = null;
    private boolean tglInFront = false;
    private boolean hGrow = true;
    private String strOn = "";
    private String strOff = "";
    private String strIndeterminate = "";
    private Label lblOn;
    private Label lblOff;
    private Label lblIndeterminate;
    private boolean bold = false;

    public P2ToggleSwitch() {
        this.init();
    }

    public P2ToggleSwitch(String text) {
        this.lblLeft.setText(text);
        this.init();
    }

    public P2ToggleSwitch(String text, boolean bold) {
        this.lblLeft.setText(text);
        this.bold = bold;
        this.init();
    }

    public P2ToggleSwitch(String text, boolean tglInFront, boolean hGrow) {
        this.lblLeft.setText(text);
        this.tglInFront = tglInFront;
        this.hGrow = hGrow;
        this.init();
    }

    public void setBold() {
        this.bold = true;
    }

    public void setLabelLeft(String lblOn, String lblOff, String lblIndeterminate) {
        this.strOn = lblOn;
        this.strOff = lblOff;
        this.strIndeterminate = lblIndeterminate;
        this.indeterminateProperty().addListener((observable2, oldValue, newValue) -> this.setLblLeft());
        this.selectedProperty().addListener((observable2, oldValue, newValue) -> this.setLblLeft());
        this.setLblLeft();
    }

    private void setLblLeft() {
        if (this.isSelected()) {
            this.lblLeft.setText(this.strOn);
        } else if (this.isIndeterminate()) {
            this.lblLeft.setText(this.strIndeterminate);
        } else {
            this.lblLeft.setText(this.strOff);
        }
    }

    public void setLabelRight(Label lblOn, Label lblOff, Label lblIndeterminate) {
        this.lblOn = lblOn;
        this.lblOff = lblOff;
        this.lblIndeterminate = lblIndeterminate;
        this.indeterminateProperty().addListener((observable2, oldValue, newValue) -> this.setRight());
        this.selectedProperty().addListener((observable2, oldValue, newValue) -> this.setRight());
        this.setRight();
    }

    public void setLabelRight(Label lblRight, String strOn, String strOff, String strIndeterminate) {
        this.lblRight = lblRight;
        this.strOn = strOn;
        this.strOff = strOff;
        this.strIndeterminate = strIndeterminate;
        this.indeterminateProperty().addListener((observable2, oldValue, newValue) -> this.setRight());
        this.selectedProperty().addListener((observable2, oldValue, newValue) -> this.setRight());
        this.setRight();
    }

    private void setRight() {
        if (this.lblOn != null && this.lblOff != null && this.lblIndeterminate != null) {
            this.lblIndeterminate.setVisible(this.isIndeterminate());
            this.lblOn.setVisible(!this.isIndeterminate() && this.isSelected());
            this.lblOff.setVisible(!this.isIndeterminate() && !this.isSelected());
        }
        if (this.lblRight != null) {
            if (this.isIndeterminate()) {
                this.lblRight.setText(this.strIndeterminate);
            } else if (this.isSelected()) {
                this.lblRight.setText(this.strOn);
            } else {
                this.lblRight.setText(this.strOff);
            }
        }
    }

    public final BooleanProperty selectedProperty() {
        return this.checkBox.selectedProperty();
    }

    public final BooleanProperty checkBoxDisableProperty() {
        return this.checkBox.disableProperty();
    }

    public void setCheckBoxDisable(boolean value) {
        this.checkBox.setDisable(value);
    }

    public final void setSelected(boolean value) {
        this.selectedProperty().set(value);
    }

    public final boolean isSelected() {
        return this.checkBox.isSelected();
    }

    public final BooleanProperty indeterminateProperty() {
        return this.checkBox.indeterminateProperty();
    }

    public final void setIndeterminate(boolean value) {
        this.checkBox.setIndeterminate(value);
    }

    public final boolean isIndeterminate() {
        return this.checkBox.isIndeterminate();
    }

    public final void setAllowIndeterminate(boolean value) {
        this.checkBox.setAllowIndeterminate(value);
    }

    public final void setText(String value) {
        this.lblLeft.setText(value);
    }

    public final String getText() {
        return this.lblLeft.getText();
    }

    public final void setTooltip(Tooltip value) {
        this.checkBox.setTooltip(value);
    }

    public final void setHGrow(boolean hGrow) {
        this.hGrow = hGrow;
        this.setCheckHgrow();
    }

    public CheckBox getCheckBox() {
        return this.checkBox;
    }

    private void init() {
        this.setAlignment(Pos.CENTER_LEFT);
        this.setSpacing(15.0);
        if (this.tglInFront) {
            this.lblLeft.setMaxWidth(Double.MAX_VALUE);
            this.getChildren().addAll((Node[])new Node[]{this.checkBox, this.lblLeft});
        } else {
            this.lblLeft.setMaxWidth(Double.MAX_VALUE);
            this.getChildren().addAll((Node[])new Node[]{this.lblLeft, this.checkBox});
        }
        this.setCheckHgrow();
        this.getStyleClass().add("pToggleSwitch");
        if (this.bold) {
            this.getStyleClass().add("pToggleSwitchBold");
        }
    }

    private void setCheckHgrow() {
        if (this.hGrow) {
            this.lblLeft.setMaxWidth(Double.MAX_VALUE);
            HBox.setHgrow(this.lblLeft, Priority.ALWAYS);
        } else {
            HBox.setHgrow(this.lblLeft, Priority.NEVER);
            this.lblLeft.setMaxWidth(Double.NEGATIVE_INFINITY);
        }
    }
}

