/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.guitools.ptipofday;

import de.p2tools.p2lib.P2ProgIcons;
import de.p2tools.p2lib.dialogs.dialog.P2DialogExtra;
import de.p2tools.p2lib.guitools.P2Button;
import de.p2tools.p2lib.guitools.P2Hyperlink;
import de.p2tools.p2lib.guitools.ptipofday.P2TipOfDay;
import de.p2tools.p2lib.guitools.ptipofday.P2TipOfDayFactory;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.StringProperty;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;

public class P2TipOfDayDialog
extends P2DialogExtra {
    private final List<P2TipOfDay> pTipList;
    private final ImageView iv = new ImageView();
    private final Label lblText = new Label();
    private final HBox hBoxHyper = new HBox();
    private final StringProperty shownProp;
    private final BooleanProperty showTip;
    private int imageSize = 0;
    private Button btnOk;
    private Button btnPrev;
    private Button btnNext;
    private final CheckBox chkShow = new CheckBox("Tips anzeigen");
    private int actTipOfDay = 0;

    public P2TipOfDayDialog(Stage stage, List<P2TipOfDay> pTipList, StringProperty shownProp, BooleanProperty showTip) {
        super(stage, null, "Tip des Tages", true, false, P2DialogExtra.DECO.NO_BORDER);
        this.pTipList = pTipList;
        this.shownProp = shownProp;
        this.showTip = showTip;
        this.init(true);
    }

    public P2TipOfDayDialog(Stage stage, List<P2TipOfDay> pTipList, StringProperty shownProp, BooleanProperty showTip, int imageSize) {
        super(stage, null, "Tip des Tages", true, false, P2DialogExtra.DECO.NO_BORDER);
        this.pTipList = pTipList;
        this.shownProp = shownProp;
        this.showTip = showTip;
        this.imageSize = imageSize;
        this.init(true);
    }

    @Override
    public void make() {
        P2TipOfDayFactory.setToolTipsFromShownString(this.pTipList, this.shownProp.getValueSafe());
        this.initTop();
        this.initButton();
    }

    private void initTop() {
        this.iv.setSmooth(true);
        this.setFirstTip();
        VBox vBoxL = new VBox(0.0);
        VBox vBoxR = new VBox(0.0);
        vBoxL.getChildren().add(this.iv);
        vBoxR.getChildren().add(this.lblText);
        this.hBoxHyper.setPadding(new Insets(0.0));
        vBoxR.getChildren().add(this.hBoxHyper);
        HBox hBox = new HBox(20.0);
        HBox.setHgrow(vBoxR, Priority.ALWAYS);
        hBox.getChildren().addAll((Node[])new Node[]{vBoxL, vBoxR});
        VBox.setVgrow(hBox, Priority.ALWAYS);
        this.getVBoxCont().getChildren().add(hBox);
    }

    private void initButton() {
        this.chkShow.selectedProperty().bindBidirectional(this.showTip);
        this.btnOk = new Button("_Ok");
        this.btnOk.setOnAction(a -> super.close());
        this.btnNext = P2Button.getButton(P2ProgIcons.ICON_BUTTON_NEXT.getImageView(), "n\u00e4chste Seite");
        this.btnNext.setOnAction(event -> this.selectActToolTip(true));
        this.btnPrev = P2Button.getButton(P2ProgIcons.ICON_BUTTON_PREV.getImageView(), "vorherige Seite");
        this.btnPrev.setOnAction(event -> this.selectActToolTip(false));
        this.addOkButton(this.btnOk);
        ButtonBar.setButtonData(this.btnPrev, ButtonBar.ButtonData.BACK_PREVIOUS);
        ButtonBar.setButtonData(this.btnNext, ButtonBar.ButtonData.NEXT_FORWARD);
        this.addAnyButton(this.btnNext);
        this.addAnyButton(this.btnPrev);
        this.getButtonBar().setButtonOrder("BX+CO");
        this.getHBoxOverButtons().getChildren().add(this.chkShow);
    }

    private void selectActToolTip(boolean next) {
        this.actTipOfDay = next ? (this.actTipOfDay < this.pTipList.size() - 1 ? ++this.actTipOfDay : 0) : (this.actTipOfDay > 0 ? --this.actTipOfDay : this.pTipList.size() - 1);
        this.setTipOfDay();
    }

    private void setTipOfDay() {
        this.pTipList.get(this.actTipOfDay).setWasShown(true);
        Image im = this.imageSize > 0 ? new Image(this.pTipList.get(this.actTipOfDay).getImage(), (double)this.imageSize, (double)this.imageSize, true, true) : new Image(this.pTipList.get(this.actTipOfDay).getImage(), 400.0, 400.0, true, true);
        this.iv.setImage(im);
        this.lblText.setText(this.pTipList.get(this.actTipOfDay).getText());
        this.hBoxHyper.getChildren().clear();
        if (this.pTipList.get(this.actTipOfDay).getHyperlinkWeb() != null) {
            P2Hyperlink hyperlinkWeb = this.pTipList.get(this.actTipOfDay).openUrlWithProgProperty() != null ? new P2Hyperlink(this.pTipList.get(this.actTipOfDay).getHyperlinkWeb(), this.pTipList.get(this.actTipOfDay).openUrlWithProgProperty()) : new P2Hyperlink(this.pTipList.get(this.actTipOfDay).getHyperlinkWeb());
            this.hBoxHyper.getChildren().add(hyperlinkWeb);
        }
        super.getStage().setTitle("Tip des Tages: " + (this.actTipOfDay + 1));
        this.shownProp.setValue(P2TipOfDayFactory.getToolTipShownString(this.pTipList));
    }

    private void setFirstTip() {
        for (int i = 0; i < this.pTipList.size(); ++i) {
            if (this.pTipList.get(i).isWasShown()) continue;
            this.actTipOfDay = i;
            break;
        }
        this.setTipOfDay();
    }
}

