/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.guitools.prange;

import de.p2tools.p2lib.tools.P2Exception;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Slider;
import javafx.scene.control.SplitMenuButton;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.util.StringConverter;

public class P2RangeBox_
extends VBox {
    private final String STR_ALLES = "Alles";
    private final int MIN_DIST = 5;
    private final int MIN_VALUE;
    private final int MAX_VALUE;
    private final IntegerProperty minValue = new SimpleIntegerProperty();
    private final IntegerProperty maxValue = new SimpleIntegerProperty();
    private final SplitMenuButton menuButton = new SplitMenuButton();
    private final Slider sliderMin = new Slider();
    private final Slider sliderMax = new Slider();
    private final Label lblMin = new Label("Von:");
    private final Label lblMax = new Label("Bis:");
    private final Label lblValueMin = new Label();
    private final Label lblValueMax = new Label();
    private String valuePrefix = "Bereich: ";
    private String unitSuffix = " Minuten";

    public P2RangeBox_(int min, int max) {
        this.checkValues(min, max);
        this.MIN_VALUE = min / 5;
        this.MAX_VALUE = max / 5;
        this.minValue.setValue(min);
        this.maxValue.setValue(max);
        this.init();
        this.initSlider();
    }

    public P2RangeBox_(int min, int max, IntegerProperty minValue, IntegerProperty maxValue) {
        this.checkValues(min, max);
        this.MIN_VALUE = min / 5;
        this.MAX_VALUE = max / 5;
        minValue.bindBidirectional(minValue);
        maxValue.bindBidirectional(maxValue);
        this.init();
        this.initSlider();
    }

    private void checkValues(int min, int max) {
        if (max <= min) {
            P2Exception.throwPException(951207534, "PRangeBox: max <= min");
        }
        if (min % 5 > 0) {
            P2Exception.throwPException(978451236, "PRangeBox: min % MIN_DIST > 0");
        }
        if (max % 5 > 0) {
            P2Exception.throwPException(987451036, "PRangeBox: max % MIN_DIST > 0");
        }
    }

    public final void setTooltip(Tooltip value) {
        this.menuButton.setTooltip(value);
    }

    public int getMinValue() {
        return this.minValue.get();
    }

    public void setMinValue(int minValue) {
        this.minValue.set(minValue);
    }

    public IntegerProperty minValueProperty() {
        return this.minValue;
    }

    public int getMaxValue() {
        return this.maxValue.get();
    }

    public void setMaxValue(int maxValue) {
        this.maxValue.set(maxValue);
    }

    public IntegerProperty maxValueProperty() {
        return this.maxValue;
    }

    public String getValuePrefix() {
        return this.valuePrefix;
    }

    public void setValuePrefix(String valuePrefix) {
        this.valuePrefix = valuePrefix;
        this.setRangeTxt();
    }

    public void setUnitSuffix(String unitSuffix) {
        this.unitSuffix = unitSuffix;
        this.setRangeTxt();
    }

    private void init() {
        this.setSpacing(5.0);
        this.setPadding(new Insets(0.0));
        HBox.setHgrow(this.menuButton, Priority.ALWAYS);
        this.menuButton.setMaxWidth(Double.MAX_VALUE);
        this.getChildren().addAll((Node[])new Node[]{this.menuButton});
        this.menuButton.setOnMouseClicked(m -> {
            if (m.getButton().equals((Object)MouseButton.PRIMARY) && m.getClickCount() == 2) {
                this.resetSlider();
            }
        });
        this.menuButton.setOnMousePressed(event -> {
            if (event.getButton().equals((Object)MouseButton.PRIMARY) && event.getClickCount() == 1) {
                if (this.menuButton.isShowing()) {
                    this.menuButton.hide();
                } else {
                    this.menuButton.show();
                }
            }
        });
        this.sliderMin.setMinWidth(300.0);
        this.sliderMax.setMinWidth(300.0);
        GridPane gridPane1 = new GridPane();
        gridPane1.setHgap(10.0);
        gridPane1.setVgap(10.0);
        gridPane1.add(this.lblMin, 0, 0);
        gridPane1.add(this.sliderMin, 1, 0);
        gridPane1.add(this.lblValueMin, 2, 0);
        GridPane gridPane2 = new GridPane();
        gridPane2.setHgap(10.0);
        gridPane2.setVgap(10.0);
        gridPane2.add(this.lblMax, 0, 0);
        gridPane2.add(this.sliderMax, 1, 0);
        gridPane2.add(this.lblValueMax, 2, 0);
        CustomMenuItem cmi1 = new CustomMenuItem(gridPane1);
        CustomMenuItem cmi2 = new CustomMenuItem(gridPane2);
        cmi1.setHideOnClick(false);
        cmi2.setHideOnClick(false);
        this.menuButton.getItems().addAll((MenuItem[])new MenuItem[]{cmi1, cmi2});
    }

    private void initSlider() {
        this.sliderMin.setMin(this.MIN_VALUE);
        this.sliderMin.setMax(this.MAX_VALUE - 1);
        this.initSlider(this.sliderMin, this.minValue);
        this.sliderMin.setValue(this.minValue.getValue() / 5);
        this.minValue.addListener(l -> this.sliderMin.setValue(this.minValue.getValue() / 5));
        this.sliderMin.valueProperty().addListener((o, oldV, newV) -> {
            if (!this.sliderMin.isValueChanging()) {
                this.setPropValue(this.minValue, (int)this.sliderMin.getValue());
                this.repairMaxValue();
            }
        });
        this.sliderMin.valueChangingProperty().addListener((observable2, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.setPropValue(this.minValue, (int)this.sliderMin.getValue());
                this.repairMaxValue();
            }
        });
        this.sliderMax.setMin(this.MIN_VALUE + 1);
        this.sliderMax.setMax(this.MAX_VALUE);
        this.initSlider(this.sliderMax, this.maxValue);
        this.sliderMax.setValue(this.maxValue.getValue() / 5);
        this.maxValue.addListener(l -> this.sliderMax.setValue(this.maxValue.getValue() / 5));
        this.sliderMax.valueProperty().addListener((o, oldV, newV) -> {
            if (!this.sliderMax.isValueChanging()) {
                this.setPropValue(this.maxValue, (int)this.sliderMax.getValue());
                this.repairMinValue();
            }
        });
        this.sliderMax.valueChangingProperty().addListener((observable2, oldValue, newValue) -> {
            if (!newValue.booleanValue()) {
                this.setPropValue(this.maxValue, (int)this.sliderMax.getValue());
                this.repairMinValue();
            }
        });
        this.setRangeTxt();
    }

    private void resetSlider() {
        this.setPropValue(this.minValue, this.MIN_VALUE);
        this.setPropValue(this.maxValue, this.MAX_VALUE);
        this.setRangeTxt();
    }

    private void initSlider(Slider slider, IntegerProperty ip) {
        slider.setShowTickLabels(true);
        slider.setMinorTickCount(1);
        slider.setMajorTickUnit(10.0);
        slider.setBlockIncrement(1.0);
        slider.setSnapToTicks(false);
        slider.setShowTickLabels(true);
        slider.setLabelFormatter(new StringConverter<Double>(){

            @Override
            public String toString(Double x) {
                if (x == (double)P2RangeBox_.this.MIN_VALUE) {
                    return "Alles";
                }
                if (x == (double)P2RangeBox_.this.MAX_VALUE) {
                    return "Alles";
                }
                int i = x.intValue();
                return "" + (i *= 5);
            }

            @Override
            public Double fromString(String string) {
                return null;
            }
        });
        slider.valueProperty().addListener(l -> this.setRangeTxt());
    }

    private void repairMinValue() {
        int height;
        int low = (int)this.sliderMin.getValue();
        if (low >= (height = (int)this.sliderMax.getValue())) {
            low = height - 1;
            low = low < 0 ? 0 : low;
            this.sliderMin.setValue(low);
            this.setPropValue(this.minValue, low);
        }
    }

    private void repairMaxValue() {
        int low = (int)this.sliderMin.getValue();
        int height = (int)this.sliderMax.getValue();
        if (height <= low) {
            height = low + 1;
            height = height > this.MAX_VALUE ? this.MAX_VALUE : height;
            this.sliderMax.setValue(height);
            this.setPropValue(this.maxValue, height);
        }
    }

    private void setPropValue(IntegerProperty ip, int value) {
        ip.setValue(value * 5);
    }

    private void setRangeTxt() {
        int minIntSlider = (int)this.sliderMin.getValue();
        int maxIntSlider = (int)this.sliderMax.getValue();
        int minInt = (int)this.sliderMin.getValue() * 5;
        int maxInt = (int)this.sliderMax.getValue() * 5;
        String text = minIntSlider == this.MIN_VALUE && maxIntSlider == this.MAX_VALUE ? this.valuePrefix + "Alles" : (minIntSlider == this.MIN_VALUE ? this.valuePrefix + "Max. " + maxInt + this.unitSuffix : (maxIntSlider == this.MAX_VALUE ? this.valuePrefix + "Min. " + minInt + this.unitSuffix : this.valuePrefix + "Von " + minInt + " bis " + maxInt + this.unitSuffix));
        this.menuButton.setText(text);
    }
}

