/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.guitools.pfiltercontrol;

import de.p2tools.p2lib.guitools.P2ComboBoxObject;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;

public class P2FilterComboBoxObject<E>
extends HBox {
    private ObservableList<E> itemsList;
    private ObjectProperty<E> selValueProperty;
    private P2ComboBoxObject<E> p2ComboBoxObject = new P2ComboBoxObject();
    private Button btnClear = new Button("X");

    public P2FilterComboBoxObject() {
        this.addCss();
        this.initHBox();
    }

    public P2FilterComboBoxObject(ObservableList<E> itemsList, ObjectProperty<E> selValueProperty) {
        this.itemsList = itemsList;
        this.selValueProperty = selValueProperty;
        this.addCss();
        this.initHBox();
        this.setCombo();
    }

    public void init(ObservableList<E> itemsList) {
        this.itemsList = itemsList;
        this.selectElement();
        this.setCombo();
    }

    public void init(ObservableList<E> itemsList, ObjectProperty<E> selVaueProperty) {
        this.itemsList = itemsList;
        this.selValueProperty = selVaueProperty;
        this.selectElement();
        this.setCombo();
    }

    public void setEditable(boolean editable) {
        this.p2ComboBoxObject.setEditable(editable);
    }

    private void addCss() {
        this.getStyleClass().add("PFilterComboBoxObject");
    }

    public void bindSelValueProperty(ObjectProperty<E> stringProperty) {
        this.unbind();
        this.selValueProperty = stringProperty;
        this.bind();
    }

    public void unbindSelValueProperty() {
        this.unbind();
        this.selValueProperty = null;
        this.p2ComboBoxObject.getSelectionModel().clearSelection();
    }

    public E getSelValue() {
        Object s = this.p2ComboBoxObject.getSelectionModel().getSelectedItem();
        return (E)s;
    }

    public ReadOnlyObjectProperty<E> getSelValueProperty() {
        ReadOnlyObjectProperty s = this.p2ComboBoxObject.getSelectionModel().selectedItemProperty();
        return s;
    }

    public void selectElement() {
        if (this.selValueProperty == null) {
            this.p2ComboBoxObject.getSelectionModel().clearSelection();
        } else {
            this.p2ComboBoxObject.setValue(this.selValueProperty.getValue());
        }
    }

    public void clearSelection() {
        this.p2ComboBoxObject.getSelectionModel().clearSelection();
    }

    private void initHBox() {
        this.p2ComboBoxObject.setMaxWidth(Double.MAX_VALUE);
        HBox.setHgrow(this.p2ComboBoxObject, Priority.ALWAYS);
        this.getChildren().addAll((Node[])new Node[]{this.p2ComboBoxObject, this.btnClear});
        this.btnClear.setOnAction(a -> this.p2ComboBoxObject.getSelectionModel().clearSelection());
    }

    private void setCombo() {
        this.setOnMouseClicked(mouseEvent -> {
            if (mouseEvent != null && mouseEvent.getButton().equals((Object)MouseButton.PRIMARY) && mouseEvent.getClickCount() == 2) {
                this.p2ComboBoxObject.getSelectionModel().clearSelection();
            }
        });
        if (this.itemsList == null) {
            return;
        }
        this.p2ComboBoxObject.setItems(this.itemsList);
        this.bind();
    }

    private void bind() {
        if (this.selValueProperty == null) {
            return;
        }
        this.p2ComboBoxObject.valueProperty().bindBidirectional(this.selValueProperty);
    }

    private void unbind() {
        if (this.selValueProperty == null) {
            this.p2ComboBoxObject.getSelectionModel().clearSelection();
            return;
        }
        this.p2ComboBoxObject.valueProperty().unbindBidirectional(this.selValueProperty);
    }
}

