/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.guitools.pclosepane;

import de.p2tools.p2lib.guitools.pclosepane.P2ClosePaneDialog;
import de.p2tools.p2lib.guitools.pclosepane.P2ClosePaneDto;
import de.p2tools.p2lib.guitools.pclosepane.P2ClosePaneFactory;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.scene.Node;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class P2ClosePaneController
extends VBox {
    private final TabPane tabPane = new TabPane();
    private final BooleanProperty INFO_IS_SHOWING;
    private final List<P2ClosePaneDto> infoDTOList;

    public P2ClosePaneController(P2ClosePaneDto infoDTO, BooleanProperty INFO_IS_SHOWING) {
        this.INFO_IS_SHOWING = INFO_IS_SHOWING;
        this.infoDTOList = new ArrayList<P2ClosePaneDto>(1);
        this.infoDTOList.add(infoDTO);
        this.initInfoPane();
    }

    public P2ClosePaneController(List<P2ClosePaneDto> infoDTOList, BooleanProperty INFO_IS_SHOWING) {
        this.INFO_IS_SHOWING = INFO_IS_SHOWING;
        this.infoDTOList = infoDTOList;
        this.initInfoPane();
    }

    public boolean arePanesShowing() {
        for (P2ClosePaneDto infoDTO : this.infoDTOList) {
            if (infoDTO.PANE_INFO_IS_RIP.get()) continue;
            return true;
        }
        return false;
    }

    private void initInfoPane() {
        for (P2ClosePaneDto infoDTO : this.infoDTOList) {
            if (infoDTO.PANE_INFO_IS_RIP.get()) {
                this.dialogInfo(infoDTO);
            }
            infoDTO.PANE_INFO_IS_RIP.addListener((u, o, n) -> {
                if (n.booleanValue()) {
                    this.dialogInfo(infoDTO);
                } else {
                    this.INFO_IS_SHOWING.set(true);
                }
                this.setTabs();
            });
        }
        this.setTabs();
    }

    private void dialogInfo(P2ClosePaneDto infoDTO) {
        new P2ClosePaneDialog(infoDTO.infoPane, infoDTO.textDialog, infoDTO.DIALOG_INFO_SIZE, infoDTO.PANE_INFO_IS_RIP, infoDTO.tabOn, infoDTO.maskerVis);
    }

    private void setTabs() {
        this.tabPane.getTabs().clear();
        for (P2ClosePaneDto infoDTO : this.infoDTOList) {
            if (infoDTO.PANE_INFO_IS_RIP.get()) continue;
            this.tabPane.getTabs().add(infoDTO.vertical ? P2ClosePaneFactory.makeTabV(infoDTO.infoPane, infoDTO.textInfo, this.INFO_IS_SHOWING, infoDTO.PANE_INFO_IS_RIP) : P2ClosePaneFactory.makeTabH(infoDTO.infoPane, infoDTO.textInfo, this.INFO_IS_SHOWING, infoDTO.PANE_INFO_IS_RIP));
        }
        if (this.tabPane.getTabs().isEmpty()) {
            this.INFO_IS_SHOWING.set(false);
        } else if (this.tabPane.getTabs().size() == 1) {
            Node node = ((Tab)this.tabPane.getTabs().get(0)).getContent();
            this.tabPane.getTabs().remove(0);
            this.getChildren().setAll((Node[])new Node[]{node});
            VBox.setVgrow(node, Priority.ALWAYS);
        } else {
            this.getChildren().setAll((Node[])new Node[]{this.tabPane});
            VBox.setVgrow(this.tabPane, Priority.ALWAYS);
        }
    }
}

