/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.guitools;

import de.p2tools.p2lib.tools.date.P2LDateFactory;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;

public class P2YearPicker
extends Spinner<Integer> {
    private ObjectProperty<Integer> objInt = null;

    public P2YearPicker() {
        this.init(P2LDateFactory.getActYearInt());
    }

    public P2YearPicker(int year, IntegerProperty integerProperty) {
        this.objInt = integerProperty.asObject();
        this.init(year);
    }

    public void setYearPicker(int year) {
        this.getValueFactory().setValue(year);
    }

    public void bindBidirectional(IntegerProperty integerProperty) {
        this.unbind();
        this.objInt = integerProperty.asObject();
        this.bindBidirectional();
    }

    private void bindBidirectional() {
        if (this.objInt != null) {
            this.getValueFactory().valueProperty().bindBidirectional(this.objInt);
        }
    }

    public void unbind() {
        if (this.objInt != null) {
            this.getValueFactory().valueProperty().unbindBidirectional(this.objInt);
        }
    }

    public String getYear() {
        return String.valueOf(this.valueFactoryProperty().getValue());
    }

    private void init(int year) {
        this.getStyleClass().add("PYearPicker");
        this.setMinWidth(Double.NEGATIVE_INFINITY);
        this.getStyleClass().add("split-arrows-horizontal");
        SpinnerValueFactory.IntegerSpinnerValueFactory valueFactory = new SpinnerValueFactory.IntegerSpinnerValueFactory(1950, 2050, year);
        this.setValueFactory(valueFactory);
        this.getValueFactory().setValue(year);
        this.bindBidirectional();
    }
}

