/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.guitools;

import de.p2tools.p2lib.tools.P2Exception;
import de.p2tools.p2lib.tools.date.P2LDateFactory;
import de.p2tools.p2lib.tools.date.P2LDateProperty;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import javafx.beans.value.ChangeListener;
import javafx.scene.control.DatePicker;

public class P2LDatePropertyPicker
extends DatePicker {
    private final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");
    private P2LDateProperty boundPLocalDateProperty = null;
    private ChangeListener<LocalDate> changeListener = null;

    public P2LDatePropertyPicker() {
        this.genChangeListener();
        this.init();
    }

    public P2LDatePropertyPicker(P2LDateProperty pDateProperty) {
        if (pDateProperty == null) {
            P2Exception.throwPException(978450201, this.getClass().toString());
        }
        this.genChangeListener();
        this.bindPDateProperty(pDateProperty);
        this.init();
    }

    private void init() {
        this.setDate();
        this.getEditor().textProperty().addListener((observable2, oldValue, newValue) -> {
            if (oldValue != null && newValue != null && !oldValue.equals(newValue)) {
                this.setDate((String)newValue);
            }
        });
    }

    private void genChangeListener() {
        this.changeListener = (observable2, oldValue, newValue) -> {
            if (newValue == null) {
                return;
            }
            if (this.getValue() == null || this.getValue() != null && !((LocalDate)this.getValue()).equals(newValue)) {
                this.setDate((LocalDate)newValue);
            }
        };
    }

    private void setDate() {
        if (this.getValue() == null) {
            if (this.boundPLocalDateProperty != null) {
                this.boundPLocalDateProperty.setPLocalDate(LocalDate.MIN);
            }
        } else if (this.boundPLocalDateProperty != null) {
            this.boundPLocalDateProperty.setPLocalDate((LocalDate)this.getValue());
        }
    }

    public void bindPDateProperty(P2LDateProperty pDateProperty) {
        if (pDateProperty == null) {
            P2Exception.throwPException(978450201, this.getClass().toString());
        }
        if (this.boundPLocalDateProperty != null) {
            this.boundPLocalDateProperty.removeListener(this.changeListener);
        }
        this.boundPLocalDateProperty = pDateProperty;
        this.boundPLocalDateProperty.addListener(this.changeListener);
        this.setValue((LocalDate)this.boundPLocalDateProperty.get());
        this.setDisable(this.boundPLocalDateProperty == null);
    }

    public void unbindPDateProperty() {
        if (this.boundPLocalDateProperty != null) {
            this.boundPLocalDateProperty.removeListener(this.changeListener);
        }
        this.boundPLocalDateProperty = null;
        this.setValue(null);
        this.setDisable(true);
    }

    public String getDate() {
        String ret = "";
        LocalDate date = (LocalDate)this.getValue();
        if (date != null) {
            ret = this.dateFormatter.format(date);
        }
        return ret;
    }

    public void setDate(LocalDate localDate) {
        this.setValue(localDate);
        this.setDate();
    }

    public void setDate(String stringDate) {
        if (stringDate == null || stringDate.isEmpty()) {
            this.setValue(null);
        } else {
            this.setValue(P2LDateFactory.fromString(stringDate));
        }
        this.setDate();
    }
}

