/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.guitools;

import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.P2ProgIcons;
import de.p2tools.p2lib.alert.P2Alert;
import javafx.beans.property.ObjectProperty;
import javafx.scene.control.Button;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.stage.Stage;

public class P2Button {
    private static Image hlpImage = null;

    private P2Button() {
    }

    public static Image getHlpImage() {
        return hlpImage;
    }

    public static void setHlpImage(Image hlpImage) {
        P2Button.hlpImage = hlpImage;
    }

    public static Button helpButton(ImageView imageView, String header, String helpText) {
        return P2Button.helpButton(P2LibConst.primaryStage, imageView, header, helpText);
    }

    public static Button helpButton(Stage stage, ImageView imageView, String header, String helpText) {
        Button btnHelp = new Button("");
        btnHelp.setTooltip(new Tooltip("Hilfe anzeigen"));
        btnHelp.setGraphic(imageView);
        btnHelp.setOnAction(a -> P2Alert.showHelpAlert(stage, header, helpText));
        return btnHelp;
    }

    public static Button helpButton(String header, String helpText) {
        return P2Button.helpButton(P2LibConst.primaryStage, header, helpText);
    }

    public static Button helpButton(Stage stage, String header, String helpText) {
        Button btnHelp = new Button("");
        btnHelp.setTooltip(new Tooltip("Hilfe anzeigen"));
        if (hlpImage == null) {
            btnHelp.setGraphic(P2ProgIcons.IMAGE_HELP.getImageView());
        } else {
            btnHelp.setGraphic(new ImageView(hlpImage));
        }
        btnHelp.setOnAction(a -> P2Alert.showHelpAlert(stage, header, helpText));
        return btnHelp;
    }

    public static Button helpButton(ObjectProperty<Stage> stageProp, String header, String helpText) {
        Button btnHelp = new Button("");
        btnHelp.setTooltip(new Tooltip("Hilfe anzeigen"));
        if (hlpImage == null) {
            btnHelp.setGraphic(P2ProgIcons.IMAGE_HELP.getImageView());
        } else {
            btnHelp.setGraphic(new ImageView(hlpImage));
        }
        btnHelp.setOnAction(a -> P2Alert.showHelpAlert((Stage)stageProp.getValue(), header, helpText));
        return btnHelp;
    }

    public static Button getButton(ImageView imageView, String helpText) {
        Button button = new Button("");
        button.setTooltip(new Tooltip(helpText));
        button.setGraphic(imageView);
        return button;
    }
}

