/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.dialogs.dialog;

import de.p2tools.p2lib.P2LibInit;
import de.p2tools.p2lib.dialogs.dialog.P2DialogFactory;
import de.p2tools.p2lib.guitools.P2GuiSize;
import de.p2tools.p2lib.guitools.P2WindowIcon;
import de.p2tools.p2lib.tools.P2InfoFactory;
import de.p2tools.p2lib.tools.log.P2Log;
import java.io.File;
import java.util.ArrayList;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Pane;
import javafx.stage.Modality;
import javafx.stage.Stage;

public class P2Dialog {
    static final ArrayList<P2Dialog> dialogList = new ArrayList();
    private static String iconPath = "";
    private StringProperty sizeConfiguration;
    private final boolean modal;
    private final boolean setOnlySize;
    private final String title;
    private final Stage ownerForCenteringDialog;
    private Scene scene = null;
    private Stage stage = null;
    private ObjectProperty<Stage> stageProp = new SimpleObjectProperty<Object>(null);
    private Pane pane = new Pane();
    private boolean done = false;

    P2Dialog(Stage ownerForCenteringDialog, StringProperty sizeConfiguration, String title, boolean modal, boolean setOnlySize) {
        this.ownerForCenteringDialog = ownerForCenteringDialog;
        this.sizeConfiguration = sizeConfiguration;
        this.modal = modal;
        this.title = title;
        this.setOnlySize = setOnlySize;
    }

    P2Dialog(Stage ownerForCenteringDialog, StringProperty sizeConfiguration, String title, boolean modal, boolean setOnlySize, String iconPath) {
        this.ownerForCenteringDialog = ownerForCenteringDialog;
        this.sizeConfiguration = sizeConfiguration;
        this.modal = modal;
        this.title = title;
        this.setOnlySize = setOnlySize;
        P2Dialog.iconPath = iconPath;
    }

    public static String getIconPath() {
        return iconPath;
    }

    public static void setIconPath(String iconPath) {
        P2Dialog.iconPath = iconPath;
    }

    public void setPane(Pane pane) {
        this.pane = pane;
    }

    public void init(boolean show) {
        try {
            P2Dialog.addDialog(this);
            if (this.sizeConfiguration == null) {
                this.scene = new Scene(this.pane);
            } else {
                int width = P2GuiSize.getSceneSize(this.sizeConfiguration, true);
                int height = P2GuiSize.getSceneSize(this.sizeConfiguration, false);
                this.scene = width > 0 && height > 0 ? new Scene(this.pane, width, height) : new Scene(this.pane);
            }
            this.stage = new Stage();
            this.stageProp.setValue(this.stage);
            this.stage.setScene(this.scene);
            this.stage.setTitle(this.title);
            if (this.modal) {
                this.stage.initModality(Modality.APPLICATION_MODAL);
            }
            this.scene.addEventHandler(KeyEvent.KEY_PRESSED, keyEvent -> {
                if (keyEvent.getCode() == KeyCode.ESCAPE) {
                    this.close();
                }
            });
            this.stage.setOnCloseRequest(e -> {
                e.consume();
                this.close();
            });
            if (P2InfoFactory.getOs() == P2InfoFactory.OperatingSystemType.LINUX) {
                this.stage.setResizable(false);
                if (this.setOnlySize) {
                    P2GuiSize.setSize(this.sizeConfiguration, this.stage);
                } else {
                    P2GuiSize.setSizePos(this.sizeConfiguration, this.stage, this.ownerForCenteringDialog);
                }
                this.scene.setOnMouseEntered(mouseEvent -> Platform.runLater(() -> {
                    if (!this.done) {
                        this.done = true;
                        if (this.setOnlySize) {
                            P2GuiSize.setSize(this.sizeConfiguration, this.stage);
                        } else {
                            P2GuiSize.setSizePos(this.sizeConfiguration, this.stage, this.ownerForCenteringDialog);
                        }
                        P2DialogFactory.addSizeListener(this.stage, this.sizeConfiguration);
                        this.stage.setResizable(true);
                    }
                }));
            } else {
                if (this.setOnlySize) {
                    P2GuiSize.setSize(this.sizeConfiguration, this.stage);
                } else {
                    P2GuiSize.setSizePos(this.sizeConfiguration, this.stage, this.ownerForCenteringDialog);
                }
                P2DialogFactory.addSizeListener(this.stage, this.sizeConfiguration);
            }
            this.stage.setOnShown(e -> {
                if (this.setOnlySize) {
                    P2GuiSize.setSize(this.sizeConfiguration, this.stage);
                } else {
                    P2GuiSize.setSizePos(this.sizeConfiguration, this.stage, this.ownerForCenteringDialog);
                }
            });
            this.updateCss();
            this.setIcon();
            this.make();
            if (show) {
                this.showDialog();
            }
        }
        catch (Exception exc) {
            P2Log.errorLog(152030145, exc);
        }
    }

    public void updateCss() {
        P2LibInit.addP2CssToScene(this.scene);
    }

    public void setIcon() {
        if (iconPath.isEmpty() || !new File(iconPath).exists()) {
            P2WindowIcon.addWindowIcon(this.stage);
            return;
        }
        try {
            Image icon = new Image(new File(iconPath).toURI().toString(), 58.0, 58.0, true, true);
            this.stage.getIcons().clear();
            this.stage.getIcons().add(0, icon);
        }
        catch (Exception ex) {
            P2Log.errorLog(204503978, ex);
            P2WindowIcon.addWindowIcon(this.stage);
        }
    }

    public void hide() {
        this.stage.hide();
    }

    public void close() {
        this.saveDialog();
        dialogList.remove(this);
        P2Log.debugLog("Anzahl Dialoge: " + dialogList.size());
        this.stage.close();
    }

    public void saveDialog() {
        P2GuiSize.getSize(this.sizeConfiguration, this.stage);
    }

    public void showDialog() {
        this.stage.requestFocus();
        this.stage.toFront();
        if (!this.stage.isShowing()) {
            if (this.modal) {
                this.stage.showAndWait();
            } else {
                this.stage.show();
            }
        }
    }

    public StringProperty getSizeConfiguration() {
        return this.sizeConfiguration;
    }

    public void setSizeConfiguration(StringProperty sizeConfiguration) {
        this.sizeConfiguration = sizeConfiguration;
    }

    public Stage getStage() {
        return this.stage;
    }

    public ObjectProperty<Stage> getStageProp() {
        return this.stageProp;
    }

    public boolean isShowing() {
        return this.stage.isShowing();
    }

    protected void make() {
    }

    private static synchronized void addDialog(P2Dialog p2Dialog) {
        boolean found = false;
        for (P2Dialog dialog : dialogList) {
            if (!dialog.equals(p2Dialog)) continue;
            found = true;
            break;
        }
        if (!found) {
            dialogList.add(p2Dialog);
        }
        P2Log.debugLog("Anzahl Dialoge: " + dialogList.size());
    }
}

