/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.dialogs;

import de.p2tools.p2lib.dialogs.WhatsNewInfo;
import de.p2tools.p2lib.dialogs.dialog.P2DialogExtra;
import de.p2tools.p2lib.guitools.P2ClipBoardContext;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.P2Hyperlink;
import de.p2tools.p2lib.tools.P2InfoFactory;
import java.util.ArrayList;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.stage.Stage;

public class WhatsNewDialog
extends P2DialogExtra {
    private final Button btnOk = new Button("_Ok");
    private final String URL_WEBSITE;
    private final StringProperty urlOpenProg;
    private final String progName;
    private final Color PROG_COLOR_MARK;
    private final Color PROG_COLOR;
    private final ArrayList<WhatsNewInfo> list;

    public WhatsNewDialog(Stage stage, String PROGRAM_NAME, String URL_WEBSITE, StringProperty SYSTEM_PROG_OPEN_URL, boolean darkMode, ArrayList<WhatsNewInfo> list) {
        super(stage, new SimpleStringProperty("600:800"), "Was gibt's neues", true, true, P2DialogExtra.DECO.NO_BORDER, true);
        this.progName = PROGRAM_NAME;
        this.URL_WEBSITE = URL_WEBSITE;
        this.urlOpenProg = SYSTEM_PROG_OPEN_URL;
        this.list = list;
        if (darkMode) {
            this.PROG_COLOR_MARK = Color.rgb(244, 244, 255);
            this.PROG_COLOR = Color.rgb(200, 200, 209);
        } else {
            this.PROG_COLOR_MARK = Color.rgb(0, 0, 75);
            this.PROG_COLOR = Color.rgb(0, 0, 75);
        }
        this.addOkButton(this.btnOk);
        this.init(true);
    }

    @Override
    public void make() {
        this.getVBoxCont().setSpacing(10.0);
        this.getVBoxCont().setPadding(new Insets(0.0));
        this.btnOk.setOnAction(a -> this.close());
        this.makeGridProgram();
        this.makeGridWhatNew();
        this.makeGridBottom();
    }

    private void makeGridProgram() {
        GridPane gridPane = this.getGridPane();
        gridPane.setPadding(new Insets(10.0));
        this.getVBoxCont().getChildren().add(gridPane);
        gridPane.getStyleClass().add("dialog-whats-new");
        int row = 0;
        Text text1 = new Text(this.progName);
        double size = Font.getDefault().getSize() * 1.2;
        text1.setFont(Font.font(null, FontWeight.BOLD, size));
        text1.setFill(this.PROG_COLOR_MARK);
        gridPane.add(text1, 0, row);
        Text text2 = new Text("Version: " + P2InfoFactory.getProgVersion());
        text2.setFill(this.PROG_COLOR);
        gridPane.add(text2, 1, row);
        Text text3 = new Text("[ Build: " + P2InfoFactory.getBuildNo() + " vom " + P2InfoFactory.getBuildDate() + " ]");
        text3.setFill(this.PROG_COLOR);
        gridPane.add(text3, 0, ++row, 2, 1);
        HBox.setHgrow(gridPane, Priority.ALWAYS);
        P2ClipBoardContext.addMenu("Infos kopieren", text1.getText() + "\n\n" + text3.getText(), (Node)gridPane);
    }

    private void makeGridWhatNew() {
        VBox vBox = new VBox();
        vBox.setPadding(new Insets(5.0));
        vBox.setSpacing(10.0);
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setFitToWidth(true);
        scrollPane.setFitToHeight(true);
        scrollPane.setContent(vBox);
        scrollPane.setPrefHeight(400.0);
        this.getVBoxCont().getChildren().add(scrollPane);
        VBox.setVgrow(scrollPane, Priority.ALWAYS);
        boolean first = true;
        for (WhatsNewInfo whatsNewInfo : this.list) {
            if (first) {
                first = false;
            } else {
                vBox.getChildren().add(new Label());
            }
            Text text = new Text(whatsNewInfo.getHeader());
            double size = Font.getDefault().getSize() * 1.1;
            text.setFont(Font.font(null, FontWeight.BOLD, size));
            text.setFill(this.PROG_COLOR_MARK);
            VBox vBoxCont = new VBox(10.0);
            vBoxCont.setAlignment(Pos.CENTER);
            vBoxCont.getChildren().add(text);
            vBox.getChildren().add(vBoxCont);
            if (!whatsNewInfo.getImage().isEmpty()) {
                ImageView imageView = new ImageView(new Image(whatsNewInfo.getImage()));
                imageView.setFitWidth(500.0);
                imageView.setPreserveRatio(true);
                HBox hBox = new HBox();
                hBox.getChildren().add(imageView);
                hBox.setAlignment(Pos.CENTER);
                vBox.getChildren().add(hBox);
            }
            Label lbl = new Label(whatsNewInfo.getText());
            lbl.setWrapText(true);
            lbl.setMinHeight(whatsNewInfo.getTaHeight());
            lbl.setMaxHeight(whatsNewInfo.getTaHeight());
            vBox.getChildren().add(lbl);
        }
    }

    private void makeGridBottom() {
        GridPane gridPane = this.getGridPane();
        gridPane.setPadding(new Insets(10.0));
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow()});
        this.getVBoxCont().getChildren().add(gridPane);
        gridPane.getStyleClass().add("dialog-whats-new");
        int row = 0;
        P2Hyperlink hyperlinkWeb = new P2Hyperlink(this.URL_WEBSITE, this.urlOpenProg);
        P2Hyperlink hyperlinkDonate = new P2Hyperlink("https://www.p2tools.de/donate/", this.urlOpenProg);
        Text text = new Text("Autor:");
        text.setFont(Font.font(null, FontWeight.BOLD, -1.0));
        text.setFill(this.PROG_COLOR_MARK);
        Text textM = new Text("w.xaver@googlemail.com");
        textM.setFont(new Font(14.0));
        textM.setFill(this.PROG_COLOR);
        P2ClipBoardContext.addMenu("Mail kopieren", "w.xaver@googlemail.com", (Node)gridPane);
        gridPane.add(text, 0, row);
        gridPane.add(new Label("Xaver W.   "), 1, row);
        gridPane.add(textM, 2, row);
        Label ta = new Label("Ideen oder Vorschl\u00e4ge zum Programm immer gerne per Mail.");
        gridPane.add(ta, 1, ++row, 2, 1);
        gridPane.add(new Label("Website:"), 0, ++row);
        gridPane.add(hyperlinkWeb, 1, row, 2, 1);
        gridPane.add(new Label("Spende:"), 0, ++row);
        gridPane.add(hyperlinkDonate, 1, row, 2, 1);
    }

    private GridPane getGridPane() {
        GridPane gridPane = new GridPane();
        gridPane.setHgap(10.0);
        gridPane.setVgap(3.0);
        gridPane.setPadding(new Insets(5.0));
        return gridPane;
    }
}

