/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.configfile;

import de.p2tools.p2lib.configfile.ConfigFile;
import de.p2tools.p2lib.configfile.ConfigRead;
import de.p2tools.p2lib.tools.duration.P2Duration;
import de.p2tools.p2lib.tools.log.P2Log;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ConfigReadZipFile {
    private ConfigReadZipFile() {
    }

    public static boolean readConfig(Path zipFilePath, ArrayList<ConfigFile> cFileList) {
        boolean ret;
        P2Duration.counterStart("readConfiguration");
        if (!Files.exists(zipFilePath, new LinkOption[0])) {
            return false;
        }
        try {
            ZipFile zipFile = new ZipFile(zipFilePath.toFile());
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            ret = true;
            block2: while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                InputStream stream = zipFile.getInputStream(entry);
                InputStreamReader in = new InputStreamReader(stream, StandardCharsets.UTF_8);
                for (ConfigFile cf : cFileList) {
                    String zipFileName;
                    String cfFileName = Path.of(cf.getFilePath(), new String[0]).getFileName().toString();
                    if (!cfFileName.equals(zipFileName = entry.getName())) continue;
                    ret = new ConfigRead(cf).read(in);
                    if (!ret) continue block2;
                    cFileList.remove(cf);
                    continue block2;
                }
            }
        }
        catch (IOException ex) {
            P2Log.errorLog(956301247, ex);
            ret = false;
        }
        P2Duration.counterStop("readConfiguration");
        return ret;
    }
}

