/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.checkforactinfos;

import de.p2tools.p2lib.checkforactinfos.FoundFactory;
import de.p2tools.p2lib.checkforactinfos.FoundFile;
import de.p2tools.p2lib.checkforactinfos.FoundFileList;
import de.p2tools.p2lib.checkforactinfos.FoundSearchDataDTO;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.guitools.P2Hyperlink;
import de.p2tools.p2lib.tools.date.P2LDateFactory;
import de.p2tools.p2lib.tools.log.P2Log;
import de.p2tools.p2lib.tools.net.PUrlTools;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TextArea;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.VBox;

public class InfoAlertsTabFactory {
    private static final int VERSION_PADDING_T = 5;
    private static final int VERSION_PADDING_B = 10;

    public static Tab addTabInfo(FoundSearchDataDTO foundSearchDataDTO) {
        if (!foundSearchDataDTO.isFoundNewInfo() || foundSearchDataDTO.getFoundFileListInfo().isEmpty()) {
            return null;
        }
        return InfoAlertsTabFactory.makeTabInfos(foundSearchDataDTO.getFoundFileListInfo());
    }

    private static Tab makeTabInfos(FoundFileList foundFileList) {
        Tab tabInfos = new Tab("Programminfos");
        tabInfos.setClosable(false);
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setFitToHeight(true);
        scrollPane.setFitToWidth(true);
        scrollPane.setPadding(new Insets(10.0));
        VBox vBox = new VBox(10.0);
        for (int i = foundFileList.size() - 1; i >= 0; --i) {
            FoundFile foundFile = (FoundFile)foundFileList.get(i);
            TextArea textArea = new TextArea(foundFile.getFileText());
            textArea.setWrapText(true);
            textArea.setEditable(false);
            vBox.getChildren().add(textArea);
            VBox.setVgrow(textArea, Priority.ALWAYS);
        }
        scrollPane.setContent(vBox);
        tabInfos.setContent(scrollPane);
        return tabInfos;
    }

    public static Tab addTabVersion(FoundSearchDataDTO foundSearchDataDTO) {
        return InfoAlertsTabFactory.makeTabVersion(foundSearchDataDTO);
    }

    private static Tab makeTabVersion(FoundSearchDataDTO foundSearchDataDTO) {
        Tab tabVersion = new Tab("neue Version");
        if (!foundSearchDataDTO.isFoundNewVersion()) {
            tabVersion.setText("aktuelle Version");
        }
        tabVersion.setClosable(false);
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setFitToHeight(true);
        scrollPane.setFitToWidth(true);
        scrollPane.setPadding(new Insets(10.0));
        GridPane gridPane = new GridPane();
        gridPane.setHgap(10.0);
        gridPane.setVgap(10.0);
        TextArea textArea = new TextArea();
        textArea.setPrefRowCount(6);
        textArea.setWrapText(true);
        textArea.setEditable(false);
        GridPane.setVgrow(textArea, Priority.ALWAYS);
        if (foundSearchDataDTO.isFoundNewVersion()) {
            textArea.setText(foundSearchDataDTO.getNewVersionText());
        } else {
            textArea.setText("Sie benutzen die aktuelle Version.");
        }
        Label lblActVersion = new Label("Aktuelle Version:");
        Label lblVersion = new Label("Neue Version:");
        Label lblWeb = new Label("Webseite:");
        Label lblDown = new Label("Download:");
        Label lblRel = new Label(foundSearchDataDTO.isFoundNewVersion() ? "\u00c4nderungen:" : "");
        Label txtActVersion = new Label(foundSearchDataDTO.getProgVersion() + "  vom: " + P2LDateFactory.getDate_yMd(foundSearchDataDTO.getProgBuildDate()));
        Label txtVersion = new Label(foundSearchDataDTO.getNewVersionNo() + "  vom: " + P2LDateFactory.getDate_yMd(foundSearchDataDTO.getNewVersionDate()));
        P2Hyperlink hyperlinkUrl = new P2Hyperlink(foundSearchDataDTO.getUrlWebsite());
        P2Hyperlink hyperlinkDownUrl = new P2Hyperlink(foundSearchDataDTO.getUrlDownload());
        int row = 0;
        lblActVersion.setPadding(new Insets(5.0, 0.0, 10.0, 0.0));
        txtActVersion.setPadding(new Insets(5.0, 0.0, 10.0, 0.0));
        lblVersion.setPadding(new Insets(5.0, 0.0, 10.0, 0.0));
        txtVersion.setPadding(new Insets(5.0, 0.0, 10.0, 0.0));
        HBox pane1 = new HBox();
        pane1.getChildren().add(lblActVersion);
        pane1.setAlignment(Pos.CENTER_LEFT);
        HBox pane2 = new HBox();
        pane2.getChildren().add(txtActVersion);
        pane2.setAlignment(Pos.CENTER_LEFT);
        HBox pane3 = new HBox();
        pane3.getChildren().add(lblVersion);
        pane3.setAlignment(Pos.CENTER_LEFT);
        HBox pane4 = new HBox();
        pane4.getChildren().add(txtVersion);
        pane4.setAlignment(Pos.CENTER_LEFT);
        gridPane.add(pane1, 0, row);
        gridPane.add(pane2, 1, row);
        if (foundSearchDataDTO.isFoundNewVersion()) {
            gridPane.add(pane3, 0, ++row);
            gridPane.add(pane4, 1, row);
        }
        gridPane.add(lblWeb, 0, ++row);
        gridPane.add(hyperlinkUrl, 1, row);
        gridPane.add(lblDown, 0, ++row);
        gridPane.add(hyperlinkDownUrl, 1, row);
        row = InfoAlertsTabFactory.getButton(foundSearchDataDTO, foundSearchDataDTO.getFoundFileListAct(), gridPane, row);
        gridPane.add(new Label(" "), 0, ++row);
        gridPane.add(lblRel, 0, ++row);
        gridPane.add(textArea, 0, ++row, 2, 1);
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow()});
        VBox vBox = new VBox(10.0);
        vBox.getChildren().add(gridPane);
        VBox.setVgrow(gridPane, Priority.ALWAYS);
        HBox hBox = new HBox(10.0);
        hBox.setAlignment(Pos.CENTER_RIGHT);
        if (foundSearchDataDTO.isFoundNewVersion()) {
            CheckBox chkShowUpdateAgain = new CheckBox("Dieses Update nochmal anzeigen");
            chkShowUpdateAgain.selectedProperty().bindBidirectional(foundSearchDataDTO.searchActAgainProperty());
            HBox hB = new HBox();
            HBox.setHgrow(hB, Priority.ALWAYS);
            hBox.getChildren().addAll((Node[])new Node[]{chkShowUpdateAgain, hB});
        }
        CheckBox chkSearchUpdate = new CheckBox("beim Programmstart nach Updates suchen");
        chkSearchUpdate.selectedProperty().bindBidirectional(foundSearchDataDTO.searchUpdateEveryDayProperty());
        hBox.getChildren().add(chkSearchUpdate);
        vBox.getChildren().addAll((Node[])new Node[]{hBox});
        scrollPane.setContent(vBox);
        tabVersion.setContent(scrollPane);
        return tabVersion;
    }

    public static Tab addTabBeta(FoundSearchDataDTO foundSearchDataDTO, boolean isBetaTab) {
        if (isBetaTab && foundSearchDataDTO.getFoundFileListBeta().isEmpty()) {
            return null;
        }
        if (!isBetaTab && foundSearchDataDTO.getFoundFileListDaily().isEmpty()) {
            return null;
        }
        if (isBetaTab ? !foundSearchDataDTO.isShowAllDownloads() && !foundSearchDataDTO.isSearchBeta() : !foundSearchDataDTO.isShowAllDownloads() && !foundSearchDataDTO.isSearchDaily()) {
            return null;
        }
        return InfoAlertsTabFactory.makeTabBeta(foundSearchDataDTO, isBetaTab);
    }

    private static Tab makeTabBeta(FoundSearchDataDTO foundSearchDataDTO, boolean beta) {
        Tab tabVersion = new Tab(beta ? "neue Beta" : "neues Daily");
        tabVersion.setClosable(false);
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setFitToHeight(true);
        scrollPane.setFitToWidth(true);
        scrollPane.setPadding(new Insets(10.0));
        GridPane gridPane = new GridPane();
        gridPane.setHgap(10.0);
        gridPane.setVgap(10.0);
        TextArea textArea = new TextArea();
        textArea.setPrefRowCount(6);
        textArea.setWrapText(true);
        textArea.setEditable(false);
        GridPane.setVgrow(textArea, Priority.ALWAYS);
        textArea.setText(beta ? foundSearchDataDTO.getNewBetaText() : foundSearchDataDTO.getNewDailyText());
        Label txtActVersion = new Label(foundSearchDataDTO.getProgVersion() + "   [Build: " + foundSearchDataDTO.getProgBuildNo() + "  vom: " + P2LDateFactory.getDate_yMd(foundSearchDataDTO.getProgBuildDate()) + "]");
        Label txtVersion = new Label();
        if (beta) {
            txtVersion.setText(foundSearchDataDTO.getNewBetaVersion() + "   [Build: " + foundSearchDataDTO.getNewBetaBuildNo() + "  vom: " + P2LDateFactory.getDate_yMd(foundSearchDataDTO.getNewBetaDate()) + "]");
        } else {
            txtVersion.setText(foundSearchDataDTO.getNewDailyVersion() + "   [Build: " + foundSearchDataDTO.getNewDailyBuild() + "  vom: " + P2LDateFactory.getDate_yMd(foundSearchDataDTO.getNewDailyDate()) + "]");
        }
        P2Hyperlink hyperlinkUrl = new P2Hyperlink(foundSearchDataDTO.getUrlWebsite());
        P2Hyperlink hyperlinkDownUrl = new P2Hyperlink(foundSearchDataDTO.getUrlDownload());
        Label lblActVersion = new Label("Aktuelle Version:");
        Label lblVersion = new Label("Neue Version:");
        Label lblWeb = new Label("Webseite:");
        Label lblDown = new Label("Download:");
        Label lblRel = new Label("\u00c4nderungen:");
        HBox pane1 = new HBox();
        pane1.getChildren().add(lblActVersion);
        pane1.setAlignment(Pos.CENTER_LEFT);
        HBox pane2 = new HBox();
        pane2.getChildren().add(txtActVersion);
        pane2.setAlignment(Pos.CENTER_LEFT);
        HBox pane3 = new HBox();
        pane3.getChildren().add(lblVersion);
        pane3.setAlignment(Pos.CENTER_LEFT);
        HBox pane4 = new HBox();
        pane4.getChildren().add(txtVersion);
        pane4.setAlignment(Pos.CENTER_LEFT);
        int row = 0;
        lblActVersion.setPadding(new Insets(5.0, 0.0, 10.0, 0.0));
        txtActVersion.setPadding(new Insets(5.0, 0.0, 10.0, 0.0));
        lblVersion.setPadding(new Insets(5.0, 0.0, 10.0, 0.0));
        txtVersion.setPadding(new Insets(5.0, 0.0, 10.0, 0.0));
        gridPane.add(pane1, 0, row);
        gridPane.add(pane2, 1, row);
        gridPane.add(pane3, 0, ++row);
        gridPane.add(pane4, 1, row);
        gridPane.add(lblWeb, 0, ++row);
        gridPane.add(hyperlinkUrl, 1, row);
        gridPane.add(lblDown, 0, ++row);
        gridPane.add(hyperlinkDownUrl, 1, row);
        row = InfoAlertsTabFactory.getButton(foundSearchDataDTO, beta ? foundSearchDataDTO.getFoundFileListBeta() : foundSearchDataDTO.getFoundFileListDaily(), gridPane, row);
        gridPane.add(new Label(" "), 0, ++row);
        gridPane.add(lblRel, 0, ++row);
        gridPane.add(textArea, 0, ++row, 2, 1);
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow()});
        RowConstraints rowConstraints = new RowConstraints();
        rowConstraints.setValignment(VPos.CENTER);
        gridPane.getRowConstraints().add(rowConstraints);
        VBox vBox = new VBox(10.0);
        vBox.getChildren().add(gridPane);
        VBox.setVgrow(gridPane, Priority.ALWAYS);
        scrollPane.setContent(vBox);
        tabVersion.setContent(scrollPane);
        return tabVersion;
    }

    private static int getButton(FoundSearchDataDTO foundSearchDataDTO, FoundFileList foundFileList, GridPane gridPane, int row) {
        if (foundFileList.isEmpty()) {
            return row;
        }
        SimpleBooleanProperty showAll = new SimpleBooleanProperty(false);
        VBox vBox = new VBox(10.0);
        Label lbl = new Label("Update laden:");
        GridPane.setValignment(lbl, VPos.TOP);
        gridPane.add(lbl, 0, ++row);
        gridPane.add(vBox, 1, row);
        for (FoundFile foundFile : foundFileList) {
            Button button = new Button();
            if (foundSearchDataDTO.getBsSearch().length == 0) {
                P2Log.sysLog("Updatesuche BS: Unbekannt, alles anzeigen");
            } else {
                boolean showAlways = false;
                for (String bsSearch : foundSearchDataDTO.getBsSearch()) {
                    if (!InfoAlertsTabFactory.getSearch(foundFile.getFileName()).contains(bsSearch)) continue;
                    showAlways = true;
                }
                if (!showAlways) {
                    button.visibleProperty().bind(showAll);
                    button.managedProperty().bind(showAll);
                }
            }
            button.setMaxWidth(Double.MAX_VALUE);
            String text = PUrlTools.getFileName(foundFile.getFileUrl());
            button.setText(text);
            button.setMnemonicParsing(false);
            button.setTooltip(new Tooltip(foundFile.getFileUrl()));
            button.setOnAction(a -> FoundFactory.downloadFile(foundSearchDataDTO, foundFile.getFileUrl()));
            vBox.getChildren().add(button);
        }
        CheckBox chkShowAll = new CheckBox("Alle Anzeigen");
        chkShowAll.selectedProperty().bindBidirectional(showAll);
        gridPane.add(chkShowAll, 0, ++row);
        return row;
    }

    private static String getSearch(String fileName) {
        try {
            String search = fileName.substring(fileName.indexOf("__") + 2);
            if (!search.contains("__")) {
                return "linux-windows";
            }
            search = search.substring(0, search.lastIndexOf("__"));
            return search.toLowerCase();
        }
        catch (Exception ignore) {
            return "linux-windows";
        }
    }
}

