/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.tools.net;

import de.p2tools.p2lib.tools.log.P2Log;
import de.p2tools.p2lib.tools.net.P2UrlConnectionFactory;
import java.net.HttpURLConnection;

public class PUrlTools {
    public static final int TIME_OUT = 10000;

    public static boolean isUrl(String fileUrl) {
        return fileUrl.toLowerCase().startsWith("http") || fileUrl.toLowerCase().startsWith("www");
    }

    public static boolean urlExists(String url) {
        try {
            HttpURLConnection con = P2UrlConnectionFactory.getUrlConnection(url);
            con.setRequestMethod("GET");
            con.setConnectTimeout(10000);
            con.setReadTimeout(10000);
            int responseCode = con.getResponseCode();
            return responseCode == 200;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static String getFileName(String path) {
        String ret = "";
        if (path != null && !path.isEmpty()) {
            ret = path.substring(path.lastIndexOf(47) + 1);
        }
        if (ret.contains("?")) {
            ret = ret.substring(0, ret.indexOf(63));
        }
        if (ret.contains("&")) {
            ret = ret.substring(0, ret.indexOf(38));
        }
        if (ret.isEmpty()) {
            P2Log.errorLog(395019631, path);
        }
        return ret;
    }

    public static String getSuffixFromUrl(String path) {
        String ret = "";
        if (path != null && !path.isEmpty() && path.contains(".")) {
            ret = path.substring(path.lastIndexOf(46) + 1);
        }
        if (ret.isEmpty()) {
            P2Log.errorLog(969871236, path);
        }
        if (ret.contains("?")) {
            ret = ret.substring(0, ret.indexOf(63));
        }
        if (ret.length() > 5) {
            ret = "---";
            P2Log.debugLog("no Suffix for URL: " + path);
        }
        return ret;
    }

    public static String getFileNameWithoutSuffix(String path) {
        String ret = "";
        if (path != null && !path.isEmpty() && path.contains(".")) {
            ret = path.substring(0, path.lastIndexOf(46));
        }
        if (ret.isEmpty()) {
            ret = path;
            P2Log.errorLog(945123647, path);
        }
        return ret;
    }

    public static String addUrl(String u1, String u2) {
        if (u1.endsWith("/")) {
            return u1 + u2;
        }
        return u1 + "/" + u2;
    }

    public static String removeHtml(String in) {
        return in.replaceAll("\\<.*?>", "");
    }
}

