/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.tools.log;

import de.p2tools.p2lib.P2LibConst;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;

public class P2Formatter
extends SimpleFormatter {
    private static final FastDateFormat HHmmss = FastDateFormat.getInstance("dd.MM.yy  HH:mm:ss");
    private static final int MSG_SIZE = 14;
    private static final int INDENT = 25;
    private static final int ADD_INFO = 25;
    private final String I = "";
    final String empty = StringUtils.leftPad("", 25);
    final String emptyEx = StringUtils.leftPad("", 10);

    @Override
    public String format(LogRecord record) {
        if (record.getThrown() == null && (record.getMessage().isEmpty() || record.getMessage().trim().equals(P2LibConst.LINE_SEPARATOR))) {
            return P2LibConst.LINE_SEPARATOR;
        }
        StringBuilder sb = new StringBuilder();
        if (record.getLevel().getLocalizedName().isEmpty()) {
            sb.append(StringUtils.leftPad("", 25));
        } else {
            sb.append("[" + HHmmss.format(new Date(record.getMillis())) + "]").append(" ").append(StringUtils.rightPad(record.getLevel().getLocalizedName() + ": ", 14));
        }
        if (record.getMessage().contains(P2LibConst.LINE_SEPARATOR)) {
            this.formatMultiLine(record.getMessage(), sb, this.empty);
        } else {
            sb.append(this.formatMessage(record)).append(P2LibConst.LINE_SEPARATOR);
        }
        if (record.getThrown() != null) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                this.formatMultiLineSimple(this.emptyEx + sw.toString(), sb, this.emptyEx);
                sb.append(P2LibConst.LINE_SEPARATOR);
                sb.append(P2LibConst.LINE_SEPARATOR);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sb.toString();
    }

    private void formatMultiLine(String msg, StringBuilder sb, String before) {
        String[] arr = msg.split(P2LibConst.LINE_SEPARATOR);
        if (arr.length == 0) {
            return;
        }
        sb.append(arr[0]);
        for (int i = 1; i < arr.length; ++i) {
            sb.append(P2LibConst.LINE_SEPARATOR);
            sb.append(before);
            if (i == arr.length - 1) {
                sb.append(arr[i]);
                continue;
            }
            sb.append(arr[i]);
        }
        sb.append(P2LibConst.LINE_SEPARATOR);
    }

    private void formatMultiLineSimple(String msg, StringBuilder sb, String before) {
        String[] arr = msg.split(P2LibConst.LINE_SEPARATOR);
        if (arr.length == 0) {
            return;
        }
        sb.append(arr[0]);
        for (int i = 1; i < arr.length; ++i) {
            sb.append(P2LibConst.LINE_SEPARATOR);
            sb.append(before);
            sb.append(arr[i]);
        }
        sb.append(P2LibConst.LINE_SEPARATOR);
    }
}

