/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.tools.file;

import de.p2tools.p2lib.tools.file.P2FileUtils;
import java.io.File;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.commons.io.FilenameUtils;

public class P2FileName {
    private static final String STR = "__";
    private static final DateTimeFormatter FORMATTER_PRE_yyyyMMdd = DateTimeFormatter.ofPattern("yyyyMMdd__");
    private static final DateTimeFormatter FORMATTER_PRE_DOT_yyyyMMdd = DateTimeFormatter.ofPattern("yyyy.MM.dd__");
    private static final DateTimeFormatter FORMATTER_PRE_yyyyMMdd_HHmm = DateTimeFormatter.ofPattern("yyyyMMdd_HHmm__");
    private static final DateTimeFormatter FORMATTER_PRE_DOT_yyyyMMdd_HHmm = DateTimeFormatter.ofPattern("yyyy.MM.dd_HH:mm__");
    private static final DateTimeFormatter FORMATTER_PRE_yyyyMMdd_HHmmss = DateTimeFormatter.ofPattern("yyyyMMdd_HHmmss__");
    private static final DateTimeFormatter FORMATTER_PRE_DOT_yyyyMMdd_HHmmss = DateTimeFormatter.ofPattern("yyyy.MM.dd_HH:mm:ss__");
    private static final DateTimeFormatter FORMATTER_AFTER_yyyyMMdd = DateTimeFormatter.ofPattern("__yyyyMMdd");
    private static final DateTimeFormatter FORMATTER_AFTER_DOT_yyyyMMdd = DateTimeFormatter.ofPattern("__yyyy.MM.dd");
    private static final DateTimeFormatter FORMATTER_AFTER_yyyyMMdd_HHmm = DateTimeFormatter.ofPattern("__yyyyMMdd_HHmm");
    private static final DateTimeFormatter FORMATTER_AFTER_DOT_yyyyMMdd_HHmm = DateTimeFormatter.ofPattern("__yyyy.MM.dd_HH:mm");
    private static final DateTimeFormatter FORMATTER_AFTER_yyyyMMdd_HHmmss = DateTimeFormatter.ofPattern("__yyyyMMdd_HHmmss");
    private static final DateTimeFormatter FORMATTER_AFTER_DOT_yyyyMMdd_HHmmss = DateTimeFormatter.ofPattern("__yyyy.MM.dd_HH:mm:ss");

    public static String getFilenameRelative(File file, String relative) {
        if (file == null) {
            return "";
        }
        String rel = file.toString();
        if (rel.startsWith(relative) && (rel = rel.replaceFirst(relative, "")).startsWith(File.separator)) {
            rel = rel.replaceFirst(File.separator, "");
        }
        return rel;
    }

    public static String getNextFileNameWithDate(String name, String suffix) {
        if (name.isEmpty()) {
            Object dotSuffix = suffix.startsWith(".") ? suffix : "." + suffix;
            name = System.getProperty("user.home");
            name = P2FileUtils.addsPath(name, "Infos" + (String)dotSuffix);
        }
        String onlyName = FilenameUtils.getName(name);
        String onlyPath = FilenameUtils.getFullPath(name);
        return P2FileName.getNextFileNameWithDate(onlyPath, onlyName, suffix);
    }

    public static String getNextFileNameWithDate(String onlyPath, String onlyFileName, String suffix) {
        if (onlyPath == null || onlyFileName == null || suffix == null) {
            return "";
        }
        String fileName = P2FileName.getNextFileNameWithDateWithOutPath(onlyFileName, suffix, false);
        fileName = P2FileUtils.addsPath(onlyPath, fileName);
        return fileName;
    }

    public static String getNextFileNameWithDateWithOutPath(String onlyFileName, String suffix) {
        return P2FileName.getNextFileNameWithDateWithOutPath(onlyFileName, suffix, false);
    }

    public static String getNextFileNameWithDateWithOutPath(String onlyFileName, String suffix, boolean yesterday) {
        if (onlyFileName == null || suffix == null) {
            return "";
        }
        Object dotSuffix = suffix.startsWith(".") ? suffix : "." + suffix;
        onlyFileName = P2FileUtils.getFileName(onlyFileName);
        String filenameNoSuffix = P2FileName.cleanName(onlyFileName, (String)dotSuffix);
        LocalDateTime date = yesterday ? LocalDateTime.now().minusDays(1L) : LocalDateTime.now();
        String datePre = FORMATTER_PRE_yyyyMMdd.format(date);
        String dateDotPre = FORMATTER_PRE_DOT_yyyyMMdd.format(date);
        String dateTimePre = FORMATTER_PRE_yyyyMMdd_HHmmss.format(date);
        String dateTimeDotPre = FORMATTER_PRE_DOT_yyyyMMdd_HHmmss.format(date);
        String dateAfter = FORMATTER_AFTER_yyyyMMdd.format(date);
        String dateDotAfter = FORMATTER_AFTER_DOT_yyyyMMdd.format(date);
        String dateTimeAfter = FORMATTER_AFTER_yyyyMMdd_HHmmss.format(date);
        String dateTimeDotAfter = FORMATTER_AFTER_DOT_yyyyMMdd_HHmmss.format(date);
        String containDatePre = P2FileName.getDateString(filenameNoSuffix, FORMATTER_PRE_yyyyMMdd);
        String containDateDotPre = P2FileName.getDateString(filenameNoSuffix, FORMATTER_PRE_DOT_yyyyMMdd);
        String containDateTimePre = P2FileName.getDateString(filenameNoSuffix, FORMATTER_PRE_yyyyMMdd_HHmmss);
        String containDateTimeDotPre = P2FileName.getDateString(filenameNoSuffix, FORMATTER_PRE_DOT_yyyyMMdd_HHmmss);
        String containDateAfter = P2FileName.getDateString(filenameNoSuffix, FORMATTER_AFTER_yyyyMMdd);
        String containDateDotAfter = P2FileName.getDateString(filenameNoSuffix, FORMATTER_AFTER_DOT_yyyyMMdd);
        String containDateTimeAfter = P2FileName.getDateString(filenameNoSuffix, FORMATTER_AFTER_yyyyMMdd_HHmmss);
        String containDateTimeDotAfter = P2FileName.getDateString(filenameNoSuffix, FORMATTER_AFTER_DOT_yyyyMMdd_HHmmss);
        if (!onlyFileName.endsWith((String)dotSuffix)) {
            String ret = filenameNoSuffix + (String)dotSuffix;
            return ret;
        }
        String ret = !containDatePre.isEmpty() ? dateDotPre + filenameNoSuffix.replace(containDatePre, "") : (!containDateDotPre.isEmpty() ? dateTimePre + filenameNoSuffix.replace(containDateDotPre, "") : (!containDateTimePre.isEmpty() ? dateTimeDotPre + filenameNoSuffix.replace(containDateTimePre, "") : (!containDateTimeDotPre.isEmpty() ? filenameNoSuffix.replace(containDateTimeDotPre, "") + dateAfter : (!containDateAfter.isEmpty() ? filenameNoSuffix.replace(containDateAfter, "") + dateDotAfter : (!containDateDotAfter.isEmpty() ? filenameNoSuffix.replace(containDateDotAfter, "") + dateTimeAfter : (!containDateTimeAfter.isEmpty() ? filenameNoSuffix.replace(containDateTimeAfter, "") + dateTimeDotAfter : (!containDateTimeDotAfter.isEmpty() ? datePre + filenameNoSuffix.replace(containDateTimeDotAfter, "") : datePre + filenameNoSuffix)))))));
        ret = ret + (String)dotSuffix;
        return ret;
    }

    private static String cleanName(String name, String suffix) {
        return FilenameUtils.removeExtension(name);
    }

    private static String getDateString(String fileName, DateTimeFormatter dateTimeFormatter) {
        if (!fileName.contains(STR)) {
            return "";
        }
        try {
            String ret = fileName.substring(fileName.lastIndexOf(STR));
            LocalDate localDate = LocalDate.parse(ret, dateTimeFormatter);
            return ret;
        }
        catch (Exception ret) {
            try {
                String ret2 = fileName.substring(0, fileName.indexOf(STR) + STR.length());
                LocalDate localDate = LocalDate.parse(ret2, dateTimeFormatter);
                return ret2;
            }
            catch (Exception exception) {
                return "";
            }
        }
    }
}

