/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.tools;

import de.p2tools.p2lib.tools.log.P2Log;
import java.text.Normalizer;
import java.util.regex.Pattern;

public class DiacriticFactory3 {
    private static final Pattern DIACRITICS_AND_FRIENDS = Pattern.compile("[\\p{InCombiningDiacriticalMarks}\\p{IsLm}\\p{IsSk}]+");

    private DiacriticFactory3() {
    }

    public static String flattenDiacritic(String string) {
        try {
            if (!(string.contains("\u00e4") || string.contains("\u00f6") || string.contains("\u00fc") || string.contains("\u00c4") || string.contains("\u00d6") || string.contains("\u00dc"))) {
                return DiacriticFactory3.strip1(string);
            }
            StringBuilder sb1 = new StringBuilder();
            StringBuilder sb2 = new StringBuilder();
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '\u00e4' || c == '\u00f6' || c == '\u00fc' || c == '\u00c4' || c == '\u00d6' || c == '\u00dc') {
                    sb1.append(DiacriticFactory3.strip1(sb2.toString()));
                    sb2.setLength(0);
                    sb1.append(c);
                    continue;
                }
                sb2.append(c);
            }
            sb1.append(DiacriticFactory3.strip1(sb2.toString()));
            return sb1.toString();
        }
        catch (Exception ex) {
            P2Log.errorLog(958587452, ex);
            return string;
        }
    }

    private static String strip1(String str) {
        str = Normalizer.normalize(str, Normalizer.Form.NFD);
        str = DIACRITICS_AND_FRIENDS.matcher(str).replaceAll("");
        return str;
    }
}

