/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.mediathek.storedaudiolist;

import de.p2tools.p2lib.configfile.ConfigFile;
import de.p2tools.p2lib.configfile.ConfigReadFile;
import de.p2tools.p2lib.mediathek.storedaudiolist.StoredAudioData;
import de.p2tools.p2lib.mediathek.storedaudiolist.StoredAudioList;
import de.p2tools.p2lib.tools.log.P2Log;
import java.util.Random;

public class StoredAudioDataFactory {
    private StoredAudioDataFactory() {
    }

    public static String getStoredAudioList() {
        StoredAudioList storedAudioList = StoredAudioDataFactory.loadStoredAudioList();
        if (!storedAudioList.isEmpty()) {
            int rInt = new Random().nextInt(storedAudioList.getSize());
            String url = ((StoredAudioData)storedAudioList.get(rInt)).getUrl();
            P2Log.sysLog("URL der AudioList: " + url);
            return url;
        }
        Random random = new Random();
        String url = random.nextBoolean() ? "https://atlist.de/audios.xz" : "https://p2atlist.de/audios.xz";
        P2Log.sysLog("URL der AudioList[STORED]: " + url);
        return url;
    }

    private static StoredAudioList loadStoredAudioList() {
        StoredAudioList storedAudioList = new StoredAudioList();
        String url = "https://p2tools.de/download/storedAtList.xml";
        try {
            ConfigFile configFile = new ConfigFile(url, false);
            configFile.addConfigs(storedAudioList);
            if (!ConfigReadFile.readConfig(configFile)) {
                P2Log.errorLog(989845214, "StoredAudioData konnten nicht geladen werden");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return storedAudioList;
    }
}

