/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.mediathek.filter;

import de.p2tools.p2lib.colordata.P2ColorData;
import de.p2tools.p2lib.mediathek.filter.Filter;
import javafx.application.Platform;
import javafx.scene.control.TextInputControl;
import javafx.scene.paint.Color;

public class FilterCheckRegEx {
    private final int COUNTER_MAX = 2500;
    public static P2ColorData COLOR_ERROR = new P2ColorData("COLOR_FILTER_REGEX_ERROR", Color.rgb(255, 230, 230), Color.rgb(170, 0, 0));
    public static P2ColorData COLOR_OK = new P2ColorData("COLOR_FILTER_REGEX", Color.rgb(225, 255, 225), Color.rgb(128, 179, 213));
    private TextInputControl tf;
    private boolean colorRed = false;
    private int counter = 0;
    private ColorThread colorThread = null;

    public FilterCheckRegEx(TextInputControl tf) {
        this.tf = tf;
        this.checkPattern();
        tf.textProperty().addListener((observable2, oldValue, newValue) -> {
            if (newValue == null) {
                return;
            }
            this.checkPattern();
        });
    }

    private void checkPattern() {
        String text = this.tf.getText();
        if (!Filter.isPattern(text)) {
            this.colorRed = false;
            this.tf.setStyle("");
        } else {
            if (Filter.makePattern(text) == null) {
                this.colorRed = true;
                this.tf.setStyle("");
                this.tf.setStyle(COLOR_ERROR.getCssBackground());
            } else {
                this.colorRed = false;
                this.tf.setStyle("");
                this.tf.setStyle(COLOR_OK.getCssBackground());
            }
            if (this.colorThread != null) {
                this.counter = 2500;
            } else {
                this.colorThread = new ColorThread();
                this.colorThread.start();
            }
        }
    }

    private class ColorThread
    extends Thread {
        public ColorThread() {
            this.setName("ColorThread");
            FilterCheckRegEx.this.counter = 2500;
        }

        @Override
        public void run() {
            try {
                while (FilterCheckRegEx.this.counter > 0) {
                    FilterCheckRegEx.this.counter -= 500;
                    ColorThread.sleep(500L);
                }
                if (!FilterCheckRegEx.this.colorRed) {
                    Platform.runLater(() -> FilterCheckRegEx.this.tf.setStyle(""));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            FilterCheckRegEx.this.colorThread = null;
        }
    }
}

