/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.mediathek.filter;

import de.p2tools.p2lib.mediathek.filmdata.FilmData;
import de.p2tools.p2lib.mediathek.filter.Filter;
import de.p2tools.p2lib.mediathek.filter.FilterCheck;

public class FilmFilterCheck {
    private FilmFilterCheck() {
    }

    public static boolean checkFilterMatch(Filter sender, Filter theme, Filter themeTitle, Filter title, Filter somewhere, FilmData filmData) {
        if (!FilmFilterCheck.checkFilterMatch(sender, theme, themeTitle, title, filmData)) {
            return false;
        }
        return somewhere.isEmpty || FilmFilterCheck.checkMatchSomewhereLowerCase(somewhere, filmData);
    }

    public static boolean checkFilterMatch(Filter sender, Filter theme, Filter themeTitle, Filter title, FilmData filmData) {
        if (!sender.isEmpty && !FilmFilterCheck.checkMatchChannelSmartLowerCase(sender, filmData)) {
            return false;
        }
        if (!theme.isEmpty && !FilmFilterCheck.checkMatchThemeExactLowerCase(theme, filmData)) {
            return false;
        }
        if (!themeTitle.isEmpty && !FilmFilterCheck.checkMatchThemeTitleLowerCase(themeTitle, filmData)) {
            return false;
        }
        return title.isEmpty || FilmFilterCheck.checkMatchTitleLowerCase(title, filmData);
    }

    public static boolean checkMatchChannelSmart(Filter sender, FilmData film) {
        for (String s : sender.filterArr) {
            if (!s.equalsIgnoreCase(film.arr[1])) continue;
            return true;
        }
        return false;
    }

    private static boolean checkMatchChannelSmartLowerCase(Filter sender, FilmData film) {
        for (String s : sender.filterArr) {
            if (!s.equals(film.FILM_CHANNEL_STR)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkMatchThemeExact(Filter theme, FilmData film) {
        return !(theme.isExact ? !theme.filter.equalsIgnoreCase(film.arr[2]) : !FilterCheck.check(theme, film.arr[2]));
    }

    private static boolean checkMatchThemeExactLowerCase(Filter theme, FilmData film) {
        return !(theme.isExact ? !theme.filterArr[0].equals(film.FILM_THEME_STR) : !FilterCheck.checkLowerCase(theme, film.arr[2], film.FILM_THEME_STR));
    }

    public static boolean checkMatchTheme(Filter theme, FilmData film) {
        return FilterCheck.check(theme, film.arr[2]);
    }

    private static boolean checkMatchThemeLowerCase(Filter theme, FilmData film) {
        return FilterCheck.checkLowerCase(theme, film.arr[2], film.FILM_THEME_STR);
    }

    public static boolean checkMatchThemeTitle(Filter themeTitle, FilmData film) {
        return FilterCheck.check(themeTitle, film.arr[2]) || FilterCheck.check(themeTitle, film.arr[3]);
    }

    private static boolean checkMatchThemeTitleLowerCase(Filter themeTitle, FilmData film) {
        return FilterCheck.checkLowerCase(themeTitle, film.arr[2], film.FILM_THEME_STR) || FilterCheck.checkLowerCase(themeTitle, film.arr[3], film.FILM_TITLE_STR);
    }

    public static boolean checkMatchTitle(Filter title, FilmData film) {
        return FilterCheck.check(title, film.arr[3]);
    }

    private static boolean checkMatchTitleLowerCase(Filter title, FilmData film) {
        return FilterCheck.checkLowerCase(title, film.arr[3], film.FILM_TITLE_STR);
    }

    public static boolean checkMatchSomewhere(Filter somewhere, FilmData film) {
        return FilterCheck.check(somewhere, film.arr[6]) || FilterCheck.check(somewhere, film.arr[2]) || FilterCheck.check(somewhere, film.arr[3]) || FilterCheck.check(somewhere, film.arr[13]);
    }

    private static boolean checkMatchSomewhereLowerCase(Filter somewhere, FilmData film) {
        return FilterCheck.checkLowerCase(somewhere, film.arr[6], film.arr[6].toLowerCase()) || FilterCheck.checkLowerCase(somewhere, film.arr[2], film.FILM_THEME_STR) || FilterCheck.checkLowerCase(somewhere, film.arr[3], film.FILM_TITLE_STR) || FilterCheck.check(somewhere, film.arr[13]);
    }

    public static boolean checkMaxDays(int maxDays, long filmTime) {
        long days = 0L;
        try {
            if (maxDays == 0) {
                days = 0L;
            } else {
                long max = 86400000L * (long)maxDays;
                days = System.currentTimeMillis() - max;
            }
        }
        catch (Exception ex) {
            days = 0L;
        }
        return FilmFilterCheck.checkDays(days, filmTime);
    }

    public static boolean checkDays(long days, long filmTime) {
        if (days == 0L) {
            return true;
        }
        return filmTime == 0L || filmTime >= days;
    }

    public static boolean checkDays(long days, FilmData film) {
        if (days == 0L) {
            return true;
        }
        long filmTime = film.filmDate.getTime();
        return filmTime == 0L || filmTime >= days;
    }

    public static boolean checkMatchUrl(Filter url, FilmData film) {
        return FilterCheck.check(url, film.arr[15]) || FilterCheck.check(url, film.arr[14]);
    }

    public static boolean checkMatchLengthMin(int filterLangth, long filmLength) {
        return filterLangth == 0 || filmLength == 0L || filmLength >= (long)filterLangth;
    }

    public static boolean checkMatchLengthMax(int filterLaenge, long filmLength) {
        return filterLaenge == 150 || filmLength == 0L || filmLength <= (long)filterLaenge;
    }

    public static boolean checkMatchLength(int filterLeangth_minute_min, int filterLength_minute_max, long filmLength) {
        return FilmFilterCheck.checkMatchLengthMin(filterLeangth_minute_min, filmLength) && FilmFilterCheck.checkMatchLengthMax(filterLength_minute_max, filmLength);
    }

    public static boolean checkMatchFilmTime(int timeMin, int timeMax, boolean invert, int filmTime) {
        boolean ret;
        if (filmTime == -1) {
            return true;
        }
        boolean bl = ret = !(timeMin != 0 && filmTime < timeMin || timeMax != 86400 && filmTime > timeMax);
        if (invert) {
            return !ret;
        }
        return ret;
    }

    public static boolean checkMatchMinDur(int minDur, FilmData film) {
        if (minDur == 0) {
            return true;
        }
        int durationMinute = film.getDurationMinute();
        return durationMinute == 0 || durationMinute >= minDur;
    }

    public static boolean checkMatchMinDur(int minDur, int durationMinute) {
        if (minDur == 0) {
            return true;
        }
        return durationMinute == 0 || durationMinute >= minDur;
    }

    public static boolean checkMatchMaxDur(int maxDur, FilmData film) {
        if (maxDur == 150) {
            return true;
        }
        int durationMinute = film.getDurationMinute();
        return durationMinute == 0 || durationMinute <= maxDur;
    }

    public static boolean checkMatchMaxDur(int maxDur, int durationMinute) {
        if (maxDur == 150) {
            return true;
        }
        return durationMinute == 0 || durationMinute <= maxDur;
    }
}

