/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.mediathek.filmlistreadwrite;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import de.p2tools.p2lib.mediathek.download.MtHttpClientProxy;
import de.p2tools.p2lib.mediathek.filmdata.FilmData;
import de.p2tools.p2lib.mediathek.filmdata.Filmlist;
import de.p2tools.p2lib.mediathek.filmlistload.P2LoadConst;
import de.p2tools.p2lib.mediathek.filmlistload.P2LoadFactory;
import de.p2tools.p2lib.mediathek.tools.P2InputStreamProgressMonitor;
import de.p2tools.p2lib.mediathek.tools.P2ProgressMonitorInputStream;
import de.p2tools.p2lib.p2event.P2Event;
import de.p2tools.p2lib.p2event.P2EventHandler;
import de.p2tools.p2lib.p2event.P2Events;
import de.p2tools.p2lib.tools.P2StringUtils;
import de.p2tools.p2lib.tools.duration.P2Duration;
import de.p2tools.p2lib.tools.log.P2Log;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class P2ReadFilmlist {
    int sumFilms = 0;
    String channel = "";
    String theme = "";
    private double progress = 0.0;
    private int countAll = 0;
    private boolean loadFromWeb = false;
    private final P2EventHandler p2EventHandler;
    private final int eventProcess;
    private final int eventLoaded;
    private final Map<String, Integer> filmsPerChannelFoundCompleteList = new TreeMap<String, Integer>();
    private final Map<String, Integer> filmsPerChannelUsed = new TreeMap<String, Integer>();
    private final Map<String, Integer> filmsPerChannelBlocked = new TreeMap<String, Integer>();
    private final Map<String, Integer> filmsPerDaysBlocked = new TreeMap<String, Integer>();
    private final Map<String, Integer> filmsPerDurationBlocked = new TreeMap<String, Integer>();

    public P2ReadFilmlist() {
        this.p2EventHandler = P2LoadConst.p2EventHandler;
        this.eventProcess = P2Events.EVENT_FILMLIST_LOAD_PROGRESS;
        this.eventLoaded = P2Events.EVENT_FILMLIST_LOAD_LOADED;
    }

    public P2ReadFilmlist(boolean film) {
        this.p2EventHandler = P2LoadConst.p2EventHandler;
        if (film) {
            this.eventProcess = P2Events.EVENT_FILMLIST_LOAD_PROGRESS;
            this.eventLoaded = P2Events.EVENT_FILMLIST_LOAD_LOADED;
        } else {
            this.eventProcess = P2Events.EVENT_AUDIO_LIST_LOAD_PROGRESS;
            this.eventLoaded = P2Events.EVENT_AUDIO_LIST_LOAD_LOADED;
        }
    }

    public void readFilmlistWebOrLocal(List<String> logList, Filmlist filmlist, String sourceFileOrUrl) {
        P2Duration.counterStart("readFilmlistWebOrLocal");
        this.countAll = 0;
        this.filmsPerChannelFoundCompleteList.clear();
        this.filmsPerChannelUsed.clear();
        this.filmsPerChannelBlocked.clear();
        this.filmsPerDaysBlocked.clear();
        this.filmsPerDurationBlocked.clear();
        logList.add("## ============================================================");
        try {
            this.progress = 0.0;
            filmlist.clear();
            if (sourceFileOrUrl.startsWith("http")) {
                logList.add("## Filmliste aus URL laden: " + sourceFileOrUrl);
                logList.add("## FilmInit wird gemacht: " + P2LoadConst.filmInitNecessary);
                this.loadFromWeb = true;
                this.processFromWeb(new URL(sourceFileOrUrl), filmlist);
            } else {
                logList.add("## Filmliste aus Datei laden: " + sourceFileOrUrl);
                logList.add("## FilmInit wird gemacht: " + P2LoadConst.filmInitNecessary);
                this.loadFromWeb = false;
                this.processFromFile(sourceFileOrUrl, filmlist);
            }
            if (P2LoadConst.stop.get()) {
                logList.add("## -> Filmliste laden abgebrochen");
                filmlist.clear();
            } else {
                logList.add("##   Erstellt am:        " + filmlist.genDate());
                logList.add("##   Anzahl Gesamtliste: " + this.countAll);
                logList.add("##   Anzahl verwendet:   " + filmlist.size());
                this.countFoundChannel(logList, filmlist);
            }
        }
        catch (MalformedURLException ex) {
            P2Log.errorLog(945120201, ex);
        }
        catch (Exception ex) {
            P2Log.errorLog(965412378, ex);
        }
        logList.add("## ============================================================");
        this.notifyLoaded();
        P2Duration.counterStop("readFilmlistWebOrLocal");
    }

    private void processFromWeb(URL source2, Filmlist filmlist) {
        block31: {
            Request.Builder builder = new Request.Builder().url(source2);
            builder.addHeader("User-Agent", P2LoadConst.userAgent);
            P2InputStreamProgressMonitor monitor = new P2InputStreamProgressMonitor(){
                private int oldProgress = 0;

                @Override
                public void progress(long bytesRead, long size) {
                    int iProgress = (int)(bytesRead * 100L / size);
                    if (iProgress != this.oldProgress) {
                        this.oldProgress = iProgress;
                        P2ReadFilmlist.this.notifyProgress(1.0 * (double)iProgress / 100.0);
                    }
                }
            };
            try (Response response = MtHttpClientProxy.getInstance().getHttpClient().newCall(builder.build()).execute();
                 ResponseBody body = response.body();){
                if (body == null || !response.isSuccessful()) break block31;
                try (P2ProgressMonitorInputStream input = new P2ProgressMonitorInputStream(body.byteStream(), body.contentLength(), monitor);
                     InputStream is = P2LoadFactory.selectDecompressor(source2.toString(), input);
                     JsonParser jp = new JsonFactory().createParser(is);){
                    this.readData(jp, filmlist);
                }
            }
            catch (Exception ex) {
                P2Log.errorLog(820147395, ex, "FilmListe: " + String.valueOf(source2));
                filmlist.clear();
            }
        }
    }

    private void processFromFile(String source2, Filmlist filmlist) {
        this.notifyProgress(-1.0);
        try (InputStream in = P2LoadFactory.selectDecompressor(source2, new FileInputStream(source2));
             JsonParser jp = new JsonFactory().createParser(in);){
            this.readData(jp, filmlist);
        }
        catch (FileNotFoundException ex) {
            P2Log.errorLog(894512369, "FilmListe existiert nicht: " + source2);
            filmlist.clear();
        }
        catch (Exception ex) {
            P2Log.errorLog(945123641, ex, "FilmListe: " + source2);
            filmlist.clear();
        }
    }

    private void readData(JsonParser jp, Filmlist filmlist) throws IOException {
        JsonToken jsonToken;
        ArrayList<String> listChannel = P2LoadFactory.getSenderListNotToLoad();
        boolean listChannelIsEmpty = listChannel.isEmpty();
        long loadFilmsMaxMilliSeconds = this.getDaysLoadingFilms();
        int loadFilmsMinDuration = P2LoadConst.SYSTEM_LOAD_FILMLIST_MIN_DURATION;
        P2LoadConst.FilmChecker checkerFilm = P2LoadConst.checkerFilm;
        if (jp.nextToken() != JsonToken.START_OBJECT) {
            throw new IllegalStateException("Expected data to start with an Object");
        }
        while ((jsonToken = jp.nextToken()) != null && jsonToken != JsonToken.END_OBJECT) {
            if (!jp.isExpectedStartArrayToken()) continue;
            for (int k = 0; k < 5; ++k) {
                filmlist.metaData[k] = jp.nextTextValue();
            }
        }
        while ((jsonToken = jp.nextToken()) != null && jsonToken != JsonToken.END_OBJECT) {
            if (!jp.isExpectedStartArrayToken()) continue;
            jp.nextToken();
            break;
        }
        while (!P2LoadConst.stop.get() && (jsonToken = jp.nextToken()) != null && jsonToken != JsonToken.END_OBJECT) {
            if (!jp.isExpectedStartArrayToken()) continue;
            Object film = filmlist.getNewElement();
            this.addValue((FilmData)film, jp);
            if (P2LoadConst.filmInitNecessary) {
                ++this.countAll;
                this.countFilm(this.filmsPerChannelFoundCompleteList, (FilmData)film);
                ((FilmData)film).init();
            }
            if (this.loadFromWeb) {
                if (((FilmData)film).arr[1].equals("rbtv") || ((FilmData)film).arr[1].equals("Radio Bremen TV")) {
                    ((FilmData)film).arr[1] = "RBTV";
                }
                if (!listChannelIsEmpty && listChannel.contains(((FilmData)film).arr[1])) {
                    this.countFilm(this.filmsPerChannelBlocked, (FilmData)film);
                    continue;
                }
                if (loadFilmsMaxMilliSeconds > 0L && !this.checkDays((FilmData)film, loadFilmsMaxMilliSeconds)) {
                    this.countFilm(this.filmsPerDaysBlocked, (FilmData)film);
                    continue;
                }
                if (loadFilmsMinDuration > 0 && !this.checkDuration((FilmData)film, loadFilmsMinDuration)) {
                    this.countFilm(this.filmsPerDurationBlocked, (FilmData)film);
                    continue;
                }
                if (checkerFilm != null && checkerFilm.check((FilmData)film)) continue;
            }
            this.countFilm(this.filmsPerChannelUsed, (FilmData)film);
            filmlist.importFilmOnlyWithNr(film);
        }
    }

    private void countFilm(Map<String, Integer> map, FilmData film) {
        if (map.containsKey(film.arr[1])) {
            map.put(film.arr[1], 1 + map.get(film.arr[1]));
        } else {
            map.put(film.arr[1], 1);
        }
    }

    private void countFoundChannel(List<String> logList, Filmlist filmlist) {
        int KEYSIZE = 12;
        P2Duration.counterStart("countFoundChannel");
        if (!this.filmsPerChannelFoundCompleteList.isEmpty()) {
            logList.add("## ------------------------------------------------------------");
            logList.add("##");
            logList.add("## == Filme pro Sender in der Gesamtliste ==");
            this.sumFilms = 0;
            this.filmsPerChannelFoundCompleteList.keySet().forEach(key -> {
                int found = this.filmsPerChannelFoundCompleteList.get(key);
                this.sumFilms += found;
                logList.add("## " + P2StringUtils.increaseString(12, key) + ": " + found);
            });
            logList.add("## --");
            logList.add("## " + P2StringUtils.increaseString(12, "=> Summe") + ": " + this.sumFilms);
            logList.add("##");
        }
        if (this.sumFilms == filmlist.size()) {
            return;
        }
        if (!this.filmsPerChannelUsed.isEmpty()) {
            logList.add("## ------------------------------------------------------------");
            logList.add("##  ");
            logList.add("## == Filme pro Sender verwendet ==");
            this.sumFilms = 0;
            this.filmsPerChannelUsed.keySet().forEach(key -> {
                int found = this.filmsPerChannelUsed.get(key);
                this.sumFilms += found;
                logList.add("## " + P2StringUtils.increaseString(12, key) + ": " + found);
            });
            logList.add("## --");
            logList.add("## " + P2StringUtils.increaseString(12, "=> Summe") + ": " + this.sumFilms);
            logList.add("## ");
        }
        if (!this.filmsPerChannelBlocked.isEmpty()) {
            logList.add("## ------------------------------------------------------------");
            logList.add("## ");
            logList.add("## == nach Sender geblockte Filme ==");
            this.sumFilms = 0;
            this.filmsPerChannelBlocked.keySet().forEach(key -> {
                int found = this.filmsPerChannelBlocked.get(key);
                this.sumFilms += found;
                logList.add("## " + P2StringUtils.increaseString(12, key) + ": " + found);
            });
            logList.add("## --");
            logList.add("## " + P2StringUtils.increaseString(12, "=> Summe") + ": " + this.sumFilms);
            logList.add("## ");
        }
        if (!this.filmsPerDaysBlocked.isEmpty()) {
            logList.add("## ------------------------------------------------------------");
            logList.add("## ");
            int maxDays = P2LoadConst.SYSTEM_LOAD_FILMLIST_MAX_DAYS;
            logList.add("## == nach max. Tage geblockte Filme (max. " + maxDays + " Tage) ==");
            this.sumFilms = 0;
            this.filmsPerDaysBlocked.keySet().forEach(key -> {
                int found = this.filmsPerDaysBlocked.get(key);
                this.sumFilms += found;
                logList.add("## " + P2StringUtils.increaseString(12, key) + ": " + found);
            });
            logList.add("## --");
            logList.add("## " + P2StringUtils.increaseString(12, "=> Summe") + ": " + this.sumFilms);
            logList.add("## ");
        }
        if (!this.filmsPerDurationBlocked.isEmpty()) {
            logList.add("## ------------------------------------------------------------");
            logList.add("## ");
            int dur = P2LoadConst.SYSTEM_LOAD_FILMLIST_MIN_DURATION;
            logList.add("## == nach Filml\u00e4nge geblockte Filme (mind. " + dur + " min.) ==");
            this.sumFilms = 0;
            this.filmsPerDurationBlocked.keySet().forEach(key -> {
                int found = this.filmsPerDurationBlocked.get(key);
                this.sumFilms += found;
                logList.add("## " + P2StringUtils.increaseString(12, key) + ": " + found);
            });
            logList.add("## --");
            logList.add("## " + P2StringUtils.increaseString(12, "=> Summe") + ": " + this.sumFilms);
            logList.add("## ");
        }
        P2Duration.counterStop("countFoundChannel");
    }

    private void addValue(FilmData film, JsonParser jp) throws IOException {
        block18: for (int i = 0; i < 20; ++i) {
            String str = jp.nextTextValue();
            switch (i) {
                case 0: {
                    if (!str.isEmpty()) {
                        this.channel = str.intern();
                    }
                    film.arr[1] = this.channel;
                    continue block18;
                }
                case 1: {
                    if (!str.isEmpty()) {
                        this.theme = str.intern();
                    }
                    film.arr[2] = this.theme;
                    continue block18;
                }
                case 2: {
                    film.arr[3] = str;
                    continue block18;
                }
                case 3: {
                    film.arr[6] = str;
                    continue block18;
                }
                case 4: {
                    film.arr[7] = str;
                    continue block18;
                }
                case 5: {
                    film.arr[8] = str;
                    continue block18;
                }
                case 6: {
                    film.arr[9] = str;
                    continue block18;
                }
                case 7: {
                    film.arr[13] = str;
                    continue block18;
                }
                case 8: {
                    film.arr[14] = str;
                    continue block18;
                }
                case 9: {
                    film.arr[15] = str;
                    continue block18;
                }
                case 10: {
                    film.arr[17] = str;
                    continue block18;
                }
                case 12: {
                    film.arr[18] = str;
                    continue block18;
                }
                case 14: {
                    film.arr[19] = str;
                    continue block18;
                }
                case 16: {
                    film.arr[22] = str;
                    continue block18;
                }
                case 18: {
                    film.arr[12] = str;
                    continue block18;
                }
                case 19: {
                    film.arr[21] = str;
                    film.setNewFilm(Boolean.parseBoolean(str));
                    continue block18;
                }
            }
        }
    }

    private long getDaysLoadingFilms() {
        long days = P2LoadConst.SYSTEM_LOAD_FILMLIST_MAX_DAYS;
        if (days > 0L) {
            return System.currentTimeMillis() - TimeUnit.MILLISECONDS.convert(days, TimeUnit.DAYS);
        }
        return 0L;
    }

    private boolean checkDays(FilmData film, long loadFilmsLastMilliSeconds) {
        try {
            if (film.filmDate.getTime() != 0L && film.filmDate.getTime() < loadFilmsLastMilliSeconds) {
                return false;
            }
        }
        catch (Exception ex) {
            P2Log.errorLog(495623014, ex);
        }
        return true;
    }

    private boolean checkDuration(FilmData film, int loadFilmsMinDuration) {
        try {
            if (film.getDurationMinute() != 0 && film.getDurationMinute() < loadFilmsMinDuration) {
                return false;
            }
        }
        catch (Exception ex) {
            P2Log.errorLog(495623014, ex);
        }
        return true;
    }

    private void notifyProgress(double iProgress) {
        this.progress = iProgress;
        if (this.progress > 1.0) {
            this.progress = 1.0;
        }
        this.p2EventHandler.notifyListener(new P2Event(this.eventProcess, "Filmliste laden", this.progress));
    }

    private void notifyLoaded() {
        this.p2EventHandler.notifyListener(new P2Event(this.eventLoaded, "Filme verarbeiten", -1.0));
    }
}

