/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.mediathek.film;

import de.p2tools.p2lib.mediathek.download.MtHttpClientProxy;
import de.p2tools.p2lib.mediathek.filmlistload.P2LoadConst;
import de.p2tools.p2lib.tools.log.P2Log;
import java.util.Objects;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import okhttp3.HttpUrl;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class SearchFilmlistUpdate {
    private final int COUNT_MAX = 900;
    private int countTimer = 600;
    private final BooleanProperty foundNewList = new SimpleBooleanProperty(false);

    public boolean isFoundNewList() {
        return this.foundNewList.get();
    }

    public BooleanProperty foundNewListProperty() {
        return this.foundNewList;
    }

    public void setFoundNewList(boolean foundNewList) {
        this.foundNewList.set(foundNewList);
    }

    public boolean check(String id) {
        this.searchNewList(id);
        return this.foundNewList.getValue();
    }

    public void hasNewFilmlist(String id) {
        if (this.foundNewList.getValue().booleanValue()) {
            return;
        }
        ++this.countTimer;
        if (this.countTimer > 900) {
            this.countTimer = 0;
            P2Log.sysLog("Gibt es eine neue Filmliste?");
            this.searchNewList(id);
        }
    }

    private void searchNewList(String id) {
        if (this.hasNewRemoteFilmlistID(id)) {
            P2Log.sysLog("Es gibt *eine* neue Filmliste");
            this.foundNewList.setValue(true);
        } else {
            P2Log.sysLog("Es gibt *keine* neue Filmliste");
            this.foundNewList.setValue(false);
        }
    }

    private boolean hasNewRemoteFilmlistID(String oldId) {
        boolean result = false;
        HttpUrl filmListUrl = HttpUrl.parse(P2LoadConst.FILMLIST_ID);
        Request request = new Request.Builder().url(Objects.requireNonNull(filmListUrl)).build();
        try (Response response = MtHttpClientProxy.getInstance().getHttpClient().newCall(request).execute();
             ResponseBody body = response.body();){
            String res;
            if (body != null && response.isSuccessful() && !(res = body.string()).isEmpty() && !res.equalsIgnoreCase(oldId)) {
                result = true;
            }
        }
        catch (Exception ex) {
            P2Log.errorLog(895012478, ex);
        }
        return result;
    }
}

