/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.mediathek.film;

import de.p2tools.p2lib.mediathek.filmdata.FilmData;
import de.p2tools.p2lib.tools.duration.P2Duration;
import de.p2tools.p2lib.tools.log.P2Log;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.SimpleTimeZone;
import javafx.beans.property.ListProperty;
import org.apache.commons.lang3.time.FastDateFormat;

public class P2FilmlistFactory {
    public static final String DATE_TIME_FORMAT = "dd.MM.yyyy, HH:mm";
    private static int countDouble = 0;

    private P2FilmlistFactory() {
    }

    public static String genDate(String[] metaData) {
        String ret;
        SimpleDateFormat sdfUtc = new SimpleDateFormat(DATE_TIME_FORMAT);
        sdfUtc.setTimeZone(new SimpleTimeZone(2, "UTC"));
        if (metaData[1].isEmpty()) {
            return metaData[0];
        }
        String date = metaData[1];
        Date filmDate = null;
        try {
            filmDate = sdfUtc.parse(date);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (filmDate == null) {
            ret = metaData[1];
        } else {
            FastDateFormat formatter = FastDateFormat.getInstance(DATE_TIME_FORMAT);
            ret = formatter.format(filmDate);
        }
        return ret;
    }

    public static void updateList(ListProperty<? extends FilmData> filmList, ListProperty<? extends FilmData> addList, boolean index, boolean replace) {
        HashSet hash = new HashSet(addList.size() + 1, 0.75f);
        if (replace) {
            addList.forEach(f -> P2FilmlistFactory.addHash(f, hash, index));
            Iterator it = filmList.iterator();
            while (it.hasNext()) {
                FilmData filmData = (FilmData)it.next();
                if (filmData.arr[1].equals("KiKA")) {
                    if (!hash.contains(filmData.arr[2] + filmData.arr[3])) continue;
                    it.remove();
                    continue;
                }
                if (index) {
                    if (!hash.contains(filmData.getIndex())) continue;
                    it.remove();
                    continue;
                }
                if (!hash.contains(filmData.getUrlForHash())) continue;
                it.remove();
            }
            addList.forEach(f -> P2FilmlistFactory.addInit(filmList, f));
        } else {
            filmList.forEach(f -> P2FilmlistFactory.addHash(f, hash, index));
            for (FilmData filmData : addList) {
                if (filmData.arr[1].equals("KiKA")) {
                    if (hash.contains(filmData.arr[2] + filmData.arr[3])) continue;
                    P2FilmlistFactory.addInit(filmList, filmData);
                    continue;
                }
                if (index) {
                    if (hash.contains(filmData.getIndex())) continue;
                    P2FilmlistFactory.addInit(filmList, filmData);
                    continue;
                }
                if (hash.contains(filmData.getUrlForHash())) continue;
                P2FilmlistFactory.addInit(filmList, filmData);
            }
        }
        hash.clear();
    }

    private static boolean addInit(ListProperty<? extends FilmData> list, Object film) {
        if (film instanceof FilmData) {
            return list.add((FilmData)film);
        }
        return false;
    }

    private static void addHash(FilmData f, HashSet<String> hash, boolean index) {
        if (f.arr[1].equals("KiKA")) {
            hash.add(f.arr[2] + f.arr[3]);
        } else if (index) {
            hash.add(f.getIndex());
        } else {
            hash.add(f.getUrlForHash());
        }
    }

    public static int markFilms(ListProperty<? extends FilmData> filmList) {
        HashSet urlHashSet = new HashSet(filmList.size(), 0.75f);
        P2Duration.counterStart("markFilms");
        try {
            countDouble = 0;
            filmList.forEach(f -> {
                f.setGeoBlocked();
                f.setInFuture();
                if (!urlHashSet.add(f.getUrl())) {
                    ++countDouble;
                    f.setDoubleUrl(true);
                }
            });
        }
        catch (Exception ex) {
            P2Log.errorLog(951024789, ex);
        }
        P2Duration.counterStop("markFilms");
        urlHashSet.clear();
        return countDouble;
    }

    public static int getAge(String strDate) {
        Date date;
        int ret = 0;
        Date now = new Date(System.currentTimeMillis());
        SimpleDateFormat sdfUtc = new SimpleDateFormat(DATE_TIME_FORMAT);
        if (!strDate.isEmpty() && (date = P2FilmlistFactory.getDate(strDate, sdfUtc)) != null && (ret = Math.round((now.getTime() - date.getTime()) / 1000L)) < 0) {
            ret = 0;
        }
        return ret;
    }

    public static int getAge(String[] metaData) {
        int ret = 0;
        Date now = new Date(System.currentTimeMillis());
        Date filmDate = P2FilmlistFactory.getAgeAsDate(metaData);
        if (filmDate != null && (ret = Math.round((now.getTime() - filmDate.getTime()) / 1000L)) < 0) {
            ret = 0;
        }
        return ret;
    }

    public static Date getAgeAsDate(String[] metaData) {
        SimpleDateFormat sdfUtc = new SimpleDateFormat(DATE_TIME_FORMAT);
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_TIME_FORMAT);
        sdfUtc.setTimeZone(new SimpleTimeZone(2, "UTC"));
        if (!metaData[1].isEmpty()) {
            String date = metaData[1];
            return P2FilmlistFactory.getDate(date, sdfUtc);
        }
        String date = metaData[0];
        return P2FilmlistFactory.getDate(date, sdf);
    }

    public static String getAgeAsStringDate(String[] metaData) {
        String ret = "";
        Date date = P2FilmlistFactory.getAgeAsDate(metaData);
        SimpleDateFormat sdfUtc = new SimpleDateFormat(DATE_TIME_FORMAT);
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_TIME_FORMAT);
        sdfUtc.setTimeZone(new SimpleTimeZone(2, "UTC"));
        if (date != null) {
            try {
                ret = sdf.format(date);
            }
            catch (Exception ignore) {
                ret = "";
            }
        }
        return ret;
    }

    private static Date getDate(String date, SimpleDateFormat df) {
        if (date.isEmpty()) {
            return null;
        }
        Date filmDate = null;
        try {
            filmDate = df.parse(date);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return filmDate;
    }

    public static boolean isTooOldOrEmpty(ListProperty<? extends FilmData> filmList, String[] metaData) {
        if (filmList.isEmpty()) {
            return true;
        }
        return P2FilmlistFactory.isOlderThan(metaData, 14400);
    }

    public static boolean isTooOld(String strAge) {
        if (strAge.isEmpty()) {
            P2Log.sysLog("Die Filmliste hat kein Alter gespeichert -> Neue laden");
            return true;
        }
        int age = P2FilmlistFactory.getAge(strAge);
        if (age == 0) {
            P2Log.sysLog("Die Filmliste hat kein Alter gespeichert -> Neue laden");
            return true;
        }
        return P2FilmlistFactory.isOlderThan(age, 14400);
    }

    public static boolean isTooOldForDiffOrEmpty(ListProperty<? extends FilmData> filmList, String[] metaData) {
        if (filmList.isEmpty()) {
            return true;
        }
        try {
            String dateMaxDiff_str = new SimpleDateFormat("yyyy.MM.dd__").format(new Date()) + "09:00:00";
            Date dateMaxDiff = new SimpleDateFormat("yyyy.MM.dd__HH:mm:ss").parse(dateMaxDiff_str);
            Date dateFilmlist = P2FilmlistFactory.getAgeAsDate(metaData);
            if (dateFilmlist != null) {
                return dateFilmlist.getTime() < dateMaxDiff.getTime();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public static boolean isTooOldForDiff(String strDate) {
        if (strDate.isEmpty()) {
            P2Log.sysLog("Die Filmliste hat kein Alter gespeichert -> Neue laden");
            return true;
        }
        try {
            String dateMaxDiff_str = new SimpleDateFormat("yyyy.MM.dd__").format(new Date()) + "09:00:00";
            Date dateMaxDiff = new SimpleDateFormat("yyyy.MM.dd__HH:mm:ss").parse(dateMaxDiff_str);
            SimpleDateFormat sdfUtc = new SimpleDateFormat(DATE_TIME_FORMAT);
            Date date = P2FilmlistFactory.getDate(strDate, sdfUtc);
            if (date != null) {
                return date.getTime() < dateMaxDiff.getTime();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public static boolean isOlderThan(String[] metaData, int second) {
        int ret = P2FilmlistFactory.getAge(metaData);
        if (ret != 0) {
            P2Log.sysLog("Die Filmliste ist " + ret / 60 + " Minuten alt");
        }
        return ret > second;
    }

    public static boolean isOlderThan(int age, int second) {
        if (age != 0) {
            P2Log.sysLog("Die Filmliste ist " + age / 60 + " Minuten alt");
        }
        return age > second;
    }
}

