/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.mediathek.download;

import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.tools.log.P2Log;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public class P2InfoFile {
    public static void writeInfoFile(String destPath, String destPathFile, String fileNameWithoutSuffix, String url, String downloadSize, String channel, String theme, String title, String date, String time, String duration, String urlWebsite, String description) {
        P2Log.sysLog(new String[]{"Infofile schreiben nach: ", destPath});
        new File(destPath).mkdirs();
        Path path = P2InfoFile.getInfoFilePath(fileNameWithoutSuffix);
        if (path == null) {
            return;
        }
        try (DataOutputStream dos = new DataOutputStream(Files.newOutputStream(path, new OpenOption[0]));
             OutputStreamWriter osw = new OutputStreamWriter(dos);
             BufferedWriter br = new BufferedWriter(osw);){
            br.write("Sender:        " + channel);
            br.write(P2LibConst.LINE_SEPARATOR);
            br.write("Thema:         " + theme);
            br.write(P2LibConst.LINE_SEPARATORx2);
            br.write("Titel:         " + title);
            br.write(P2LibConst.LINE_SEPARATORx2);
            br.write("Datum:         " + date);
            br.write(P2LibConst.LINE_SEPARATOR);
            br.write("Zeit:          " + time);
            br.write(P2LibConst.LINE_SEPARATOR);
            br.write("Dauer [min]:   " + duration);
            br.write(P2LibConst.LINE_SEPARATOR);
            br.write("Gr\u00f6\u00dfe [MB]:    " + downloadSize);
            br.write(P2LibConst.LINE_SEPARATORx2);
            br.write("Website" + P2LibConst.LINE_SEPARATOR);
            br.write(urlWebsite);
            br.write(P2LibConst.LINE_SEPARATORx2);
            br.write("Url" + P2LibConst.LINE_SEPARATOR);
            br.write(url);
            br.write(P2LibConst.LINE_SEPARATORx2);
            if (!description.isEmpty()) {
                int anz = 0;
                for (String s : description.split(" ")) {
                    br.write(s + " ");
                    if ((anz += s.length()) <= 50) continue;
                    br.write(P2LibConst.LINE_SEPARATOR);
                    anz = 0;
                }
            }
            br.write(P2LibConst.LINE_SEPARATORx2);
            br.flush();
            P2Log.sysLog(new String[]{"Infofile", "  geschrieben"});
        }
        catch (IOException ex) {
            P2Log.errorLog(975410369, destPathFile);
        }
    }

    public static Path getInfoFilePath(String fileNameWithoutSuffix) {
        Path path;
        try {
            path = Paths.get(P2InfoFile.getInfoFileStr(fileNameWithoutSuffix), new String[0]);
        }
        catch (Exception ex) {
            path = null;
            P2Log.errorLog(987451202, "InfofilePath");
        }
        return path;
    }

    private static String getInfoFileStr(String fileNameWithoutSuffix) {
        return fileNameWithoutSuffix + ".txt";
    }
}

