/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.mediathek.download;

import de.p2tools.p2lib.tools.log.P2Log;
import java.util.concurrent.Semaphore;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;

public class MtBandwidthTokenBucket {
    public static final int DEFAULT_BUFFER_SIZE = 4096;
    private final Semaphore bucketSize = new Semaphore(0, false);
    public static final int BANDWIDTH_MAX_BYTE = 10000000;
    public static final int BANDWIDTH_RUN_FREE = 0;
    public static final int BANDWIDTH_PAUSE_MAX_BYTE = 50000;
    private volatile int bucketCapacityByte = 0;
    private MVBandwidthTokenBucketFillerThread fillerThread = null;
    private final IntegerProperty bandwidthValueByte;
    private final BooleanProperty pauseDownloadCapacity;

    public MtBandwidthTokenBucket(IntegerProperty bandwidthValueByte, BooleanProperty pauseDownloadCapacity) {
        this.bandwidthValueByte = bandwidthValueByte;
        this.pauseDownloadCapacity = pauseDownloadCapacity;
        this.setBucketCapacityByte(this.getBandwidth());
        this.bandwidthValueByte.addListener(l -> {
            P2Log.sysLog("change bucketCapacity: " + this.getBandwidth() + " bytesPerSecond");
            this.setBucketCapacityByte(this.getBandwidth());
        });
        this.pauseDownloadCapacity.addListener(l -> {
            P2Log.sysLog("change bucketCapacity: " + this.getBandwidth() + " bytesPerSecond");
            this.setBucketCapacityByte(this.getBandwidth());
        });
    }

    public synchronized void ensureBucketThreadIsRunning() {
        if (this.fillerThread == null) {
            this.fillerThread = new MVBandwidthTokenBucketFillerThread();
            this.fillerThread.start();
        }
    }

    public void takeBlocking(int howMany) {
        if (this.getBucketCapacityByte() > 0) {
            try {
                this.bucketSize.acquire(howMany);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void takeBlocking() {
        this.takeBlocking(1);
    }

    public synchronized int getBucketCapacityByte() {
        return this.bucketCapacityByte;
    }

    private void terminateFillerThread() {
        if (this.fillerThread != null) {
            this.fillerThread.interrupt();
            this.fillerThread = null;
        }
    }

    public synchronized void setBucketCapacityByte(int bucketCapacityByte) {
        this.bucketCapacityByte = bucketCapacityByte;
        this.terminateFillerThread();
        if (bucketCapacityByte == 0) {
            while (this.bucketSize.hasQueuedThreads()) {
                this.bucketSize.release();
            }
            this.bucketSize.drainPermits();
        } else {
            this.bucketSize.drainPermits();
            this.ensureBucketThreadIsRunning();
        }
    }

    private int getBandwidth() {
        int bytesPerSecond;
        if (this.pauseDownloadCapacity.getValue().booleanValue()) {
            return 50000;
        }
        try {
            bytesPerSecond = this.bandwidthValueByte.get();
        }
        catch (Exception ex) {
            P2Log.errorLog(612547803, ex, "reset Bandwidth");
            bytesPerSecond = 0;
            this.bandwidthValueByte.set(0);
        }
        return bytesPerSecond;
    }

    private class MVBandwidthTokenBucketFillerThread
    extends Thread {
        public MVBandwidthTokenBucketFillerThread() {
            this.setName("MLBandwidthTokenBucket Filler Thread");
        }

        @Override
        public void run() {
            try {
                int bucketCapacity;
                while (!this.isInterrupted() && (bucketCapacity = MtBandwidthTokenBucket.this.getBucketCapacityByte()) != 0) {
                    int releaseCount = bucketCapacity / 2 - MtBandwidthTokenBucket.this.bucketSize.availablePermits();
                    if (releaseCount > 0) {
                        MtBandwidthTokenBucket.this.bucketSize.release(releaseCount);
                    }
                    MVBandwidthTokenBucketFillerThread.sleep(500L);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

