/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.mediathek.audiolistload;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import de.p2tools.p2lib.mediathek.filmdata.FilmData;
import de.p2tools.p2lib.mediathek.filmdata.FilmDataProps;
import de.p2tools.p2lib.mediathek.filmdata.Filmlist;
import de.p2tools.p2lib.mediathek.filmlistload.P2LoadConst;
import de.p2tools.p2lib.mediathek.filmlistload.P2LoadFactory;
import de.p2tools.p2lib.tools.log.P2Log;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;

public class P2ReadAudioWebToFilmListJasonParser {
    private String channel = "";
    private String genre = "";
    private String theme = "";

    public void readAudioData(JsonParser jp, Filmlist filmList) throws IOException {
        JsonToken jsonToken;
        ArrayList<String> listChannel = P2LoadFactory.getSenderListNotToLoad();
        boolean listChannelIsEmpty = listChannel.isEmpty();
        long loadFilmsMaxMilliSeconds = this.getDaysLoadingFilms();
        int loadFilmsMinDuration = P2LoadConst.SYSTEM_LOAD_FILMLIST_MIN_DURATION;
        P2LoadConst.FilmChecker checkerAudio = P2LoadConst.checkerAudio;
        if (jp.nextToken() != JsonToken.START_OBJECT) {
            throw new IllegalStateException("Expected data to start with an Object");
        }
        while ((jsonToken = jp.nextToken()) != null && jsonToken != JsonToken.END_OBJECT) {
            if (!jp.isExpectedStartArrayToken()) continue;
            for (int k = 0; k < 2; ++k) {
                filmList.metaData[k] = jp.nextTextValue();
            }
        }
        while ((jsonToken = jp.nextToken()) != null && jsonToken != JsonToken.END_OBJECT) {
            if (!jp.isExpectedStartArrayToken()) continue;
            jp.nextToken();
            break;
        }
        while ((jsonToken = jp.nextToken()) != null && jsonToken != JsonToken.END_OBJECT) {
            if (!jp.isExpectedStartArrayToken()) continue;
            Object audioData = filmList.getNewElement();
            try {
                this.addValue((FilmData)audioData, jp);
                ((FilmData)audioData).init();
                if (!listChannelIsEmpty && listChannel.contains(((FilmDataProps)audioData).getChannel()) || loadFilmsMaxMilliSeconds > 0L && !this.checkDays((FilmData)audioData, loadFilmsMaxMilliSeconds) || loadFilmsMinDuration > 0 && !this.checkDuration((FilmData)audioData, loadFilmsMinDuration) || checkerAudio != null && checkerAudio.check((FilmData)audioData)) continue;
                filmList.importFilmOnlyWithNr(audioData);
            }
            catch (Exception ex) {
                System.out.println(ex);
            }
        }
    }

    private void addValue(FilmData filmData, JsonParser jp) throws IOException {
        block13: for (int i = 0; i < 14; ++i) {
            String str = jp.nextTextValue();
            switch (i) {
                case 0: {
                    if (!str.isEmpty()) {
                        this.channel = str.intern();
                    }
                    filmData.arr[1] = this.channel;
                    continue block13;
                }
                case 1: {
                    if (!str.isEmpty()) {
                        this.genre = str.intern();
                    }
                    filmData.arr[2] = this.genre;
                    continue block13;
                }
                case 3: {
                    filmData.arr[3] = str;
                    continue block13;
                }
                case 4: {
                    filmData.arr[6] = str;
                    continue block13;
                }
                case 5: {
                    filmData.arr[7] = str + ":00";
                    continue block13;
                }
                case 6: {
                    filmData.arr[8] = str;
                    continue block13;
                }
                case 7: {
                    filmData.arr[9] = str;
                    continue block13;
                }
                case 8: {
                    filmData.arr[13] = str;
                    continue block13;
                }
                case 9: {
                    filmData.arr[14] = str;
                    continue block13;
                }
                case 10: {
                    filmData.arr[15] = str;
                    continue block13;
                }
                case 11: {
                    filmData.arr[21] = str;
                }
            }
        }
    }

    private boolean checkDays(FilmData film, long loadFilmsLastMilliSeconds) {
        try {
            if (film.filmDate.getTime() != 0L && film.filmDate.getTime() < loadFilmsLastMilliSeconds) {
                return false;
            }
        }
        catch (Exception ex) {
            P2Log.errorLog(495623014, ex);
        }
        return true;
    }

    private boolean checkDuration(FilmData film, int loadFilmsMinDuration) {
        try {
            if (film.getDurationMinute() != 0 && film.getDurationMinute() < loadFilmsMinDuration) {
                return false;
            }
        }
        catch (Exception ex) {
            P2Log.errorLog(495623014, ex);
        }
        return true;
    }

    private long getDaysLoadingFilms() {
        long days = P2LoadConst.SYSTEM_LOAD_FILMLIST_MAX_DAYS;
        if (days > 0L) {
            return System.currentTimeMillis() - TimeUnit.MILLISECONDS.convert(days, TimeUnit.DAYS);
        }
        return 0L;
    }
}

