/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.mediathek.audiolistload;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import de.p2tools.p2lib.mediathek.audiodata.AudioData;
import de.p2tools.p2lib.mediathek.audiodata.AudioList;
import java.io.IOException;

public class P2ReadAudioWebToAudioList {
    private String channel = "";
    private String genre = "";
    private String theme = "";

    public void readData(JsonParser jp, AudioList audioList) throws IOException {
        JsonToken jsonToken;
        if (jp.nextToken() != JsonToken.START_OBJECT) {
            throw new IllegalStateException("Expected data to start with an Object");
        }
        while ((jsonToken = jp.nextToken()) != null && jsonToken != JsonToken.END_OBJECT) {
            if (!jp.isExpectedStartArrayToken()) continue;
            for (int k = 0; k < 2; ++k) {
                audioList.metaData[k] = jp.nextTextValue();
            }
        }
        while ((jsonToken = jp.nextToken()) != null && jsonToken != JsonToken.END_OBJECT) {
            if (!jp.isExpectedStartArrayToken()) continue;
            jp.nextToken();
            break;
        }
        while ((jsonToken = jp.nextToken()) != null && jsonToken != JsonToken.END_OBJECT) {
            if (!jp.isExpectedStartArrayToken()) continue;
            AudioData audioData = new AudioData();
            try {
                this.addValue(audioData, jp);
                audioData.init();
                audioList.importAudioOnlyWithNr(audioData);
            }
            catch (Exception ex) {
                System.out.println(ex);
            }
        }
    }

    private void addValue(AudioData audioData, JsonParser jp) throws IOException {
        block16: for (int i = 0; i < 14; ++i) {
            String str = jp.nextTextValue();
            switch (i) {
                case 0: {
                    if (!str.isEmpty()) {
                        this.channel = str.intern();
                    }
                    audioData.arr[1] = this.channel;
                    continue block16;
                }
                case 1: {
                    if (!str.isEmpty()) {
                        this.genre = str.intern();
                    }
                    audioData.arr[2] = this.genre;
                    continue block16;
                }
                case 2: {
                    if (!str.isEmpty()) {
                        this.theme = str.intern();
                    }
                    audioData.arr[3] = this.theme;
                    continue block16;
                }
                case 3: {
                    audioData.arr[4] = str;
                    continue block16;
                }
                case 4: {
                    audioData.arr[7] = str;
                    continue block16;
                }
                case 5: {
                    audioData.arr[8] = str;
                    continue block16;
                }
                case 6: {
                    audioData.arr[9] = str;
                    continue block16;
                }
                case 7: {
                    audioData.arr[10] = str;
                    continue block16;
                }
                case 8: {
                    audioData.arr[11] = str;
                    continue block16;
                }
                case 9: {
                    audioData.arr[12] = str;
                    continue block16;
                }
                case 10: {
                    audioData.arr[13] = str;
                    continue block16;
                }
                case 11: {
                    audioData.arr[14] = str;
                    continue block16;
                }
                case 12: {
                    audioData.arr[15] = str;
                    continue block16;
                }
                case 13: {
                    audioData.arr[16] = str;
                }
            }
        }
    }
}

