/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.icons;

import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.icons.P2ImageView;
import de.p2tools.p2lib.tools.log.P2Log;
import java.util.ArrayList;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;

public class P2Image {
    public static String BW_WHITE = "__bw_w";
    public static String BW_BLACK = "__bw_b";
    private static boolean checkDone = false;
    private final String longPath;
    private final String fileName;
    private final String fileNameDark;
    private int w = 0;
    private int h = 0;

    public P2Image(String longPath, String fileName) {
        this.longPath = longPath;
        this.fileName = fileName;
        this.fileNameDark = "";
        P2Image.check();
    }

    public P2Image(String longPath, String fileName, int w, int h) {
        this.longPath = longPath;
        this.fileName = fileName;
        this.fileNameDark = "";
        this.w = w;
        this.h = h;
        P2Image.check();
    }

    public P2Image(String longPath, String fileName, String fileNameDark, int w, int h) {
        this.longPath = longPath;
        this.fileName = fileName;
        this.fileNameDark = fileNameDark;
        this.w = w;
        this.h = h;
        P2Image.check();
    }

    public String getLongPath() {
        return this.longPath;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFileNameDark() {
        return this.fileNameDark;
    }

    public int getW() {
        return this.w;
    }

    public void setW(int w) {
        this.w = w;
    }

    public int getH() {
        return this.h;
    }

    public void setH(int h) {
        this.h = h;
    }

    public Image getImage() {
        try {
            if (P2LibConst.darkMode.get() && !this.fileNameDark.isEmpty()) {
                Image image = new Image(this.longPath + this.fileNameDark, (double)this.w, (double)this.h, false, true);
                return image;
            }
            Image image = new Image(this.longPath + this.fileName, (double)this.w, (double)this.h, false, true);
            return image;
        }
        catch (Exception ex) {
            P2Log.errorLog(959587451, ex.getLocalizedMessage());
            return null;
        }
    }

    public Image getBwImage() {
        try {
            String fn = this.fileName;
            fn = P2LibConst.darkMode.get() ? fn.replace(".png", BW_BLACK + ".png") : fn.replace(".png", BW_WHITE + ".png");
            Image image = new Image(this.longPath + fn, (double)this.w, (double)this.h, false, true);
            return image;
        }
        catch (Exception ex) {
            P2Log.errorLog(912547895, ex.getLocalizedMessage());
            return null;
        }
    }

    public Image getImage(int w, int h) {
        this.setW(w);
        this.setH(h);
        return this.getImage();
    }

    public ImageView getImageView(int w, int h) {
        Image img = this.getImage(w, h);
        if (img == null) {
            return new ImageView();
        }
        return new P2ImageView(this, img);
    }

    public ImageView getImageView() {
        Image img = this.getImage();
        if (img == null) {
            return new ImageView();
        }
        return new P2ImageView(this, img);
    }

    public static void check() {
        if (checkDone) {
            return;
        }
        checkDone = true;
        P2LibConst.darkMode.addListener((u, o, n) -> P2Image.getAllNodes(P2LibConst.primaryStage.getScene().getRoot()));
        P2LibConst.blackWhite.addListener((u, o, n) -> P2Image.getAllNodes(P2LibConst.primaryStage.getScene().getRoot()));
    }

    public static void getAllNodes(Parent root) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        P2Image.add(root, nodes);
        int i = 0;
        for (Node node : nodes) {
            if (!node.getClass().equals(P2ImageView.class)) continue;
            ((P2ImageView)node).setColor();
            ++i;
        }
        P2Log.sysLog("Image von --> " + i + " <-- Nodes ge\u00e4ndert");
    }

    private static void add(Parent parent, ArrayList<Node> nodes) {
        for (Node node : parent.getChildrenUnmodifiable()) {
            nodes.add(node);
            if (!(node instanceof Parent)) continue;
            P2Image.add((Parent)node, nodes);
        }
    }
}

