/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.guitools.pnotification;

import de.p2tools.p2lib.guitools.pnotification.P2Notify;
import javafx.geometry.Pos;
import javafx.stage.Popup;
import javafx.stage.Screen;
import javafx.stage.Stage;

public class P2NotificationFactory {
    private P2NotificationFactory() {
    }

    static void preOrder(Pos popupLocation, double spacingY) {
        if (P2Notify.popups.isEmpty()) {
            return;
        }
        double actPosX = P2NotificationFactory.getStartPosX(P2Notify.stageRef, popupLocation, P2Notify.offsetX, P2Notify.width);
        double actPosY = P2NotificationFactory.getStartPosY(P2Notify.stageRef, popupLocation, P2Notify.offsetY);
        block3: for (int i = 0; i < P2Notify.popups.size(); ++i) {
            Popup pop = (Popup)P2Notify.popups.get(i);
            pop.setX(actPosX);
            switch (popupLocation) {
                case TOP_LEFT: 
                case TOP_CENTER: 
                case TOP_RIGHT: {
                    pop.setY(actPosY);
                    actPosY = actPosY + pop.getHeight() + spacingY;
                    continue block3;
                }
                default: {
                    pop.setY(actPosY -= pop.getHeight());
                    actPosY -= spacingY;
                }
            }
        }
    }

    private static double getStartPosY(Stage stageRef, Pos popupLocation, double offsetY) {
        if (null == stageRef) {
            return P2NotificationFactory.calcStartPosY(popupLocation, offsetY, 0.0, Screen.getPrimary().getBounds().getHeight());
        }
        return P2NotificationFactory.calcStartPosY(popupLocation, offsetY, stageRef.getY(), stageRef.getHeight());
    }

    private static double getStartPosX(Stage stageRef, Pos popupLocation, double offsetX, double width) {
        if (null == stageRef) {
            return P2NotificationFactory.calcStartPosX(popupLocation, offsetX, width, 0.0, Screen.getPrimary().getBounds().getWidth());
        }
        return P2NotificationFactory.calcStartPosX(popupLocation, offsetX, width, stageRef.getX(), stageRef.getWidth());
    }

    private static double calcStartPosY(Pos popupLocation, double offsetY, double TOP, double TOTAL_HEIGHT) {
        return switch (popupLocation) {
            case Pos.TOP_LEFT, Pos.TOP_CENTER, Pos.TOP_RIGHT -> TOP + offsetY;
            case Pos.CENTER_LEFT, Pos.CENTER, Pos.CENTER_RIGHT -> TOP + TOTAL_HEIGHT / 2.0 - offsetY;
            case Pos.BOTTOM_LEFT, Pos.BOTTOM_CENTER, Pos.BOTTOM_RIGHT -> TOP + TOTAL_HEIGHT - offsetY;
            default -> 0.0;
        };
    }

    private static double calcStartPosX(Pos popupLocation, double offsetX, double width, double LEFT, double TOTAL_WIDTH) {
        return switch (popupLocation) {
            case Pos.TOP_LEFT, Pos.BOTTOM_LEFT, Pos.CENTER_LEFT -> LEFT + offsetX;
            case Pos.TOP_CENTER, Pos.BOTTOM_CENTER, Pos.CENTER -> LEFT + (TOTAL_WIDTH - width) * 0.5 - offsetX;
            case Pos.TOP_RIGHT, Pos.BOTTOM_RIGHT, Pos.CENTER_RIGHT -> LEFT + TOTAL_WIDTH - width - offsetX;
            default -> 0.0;
        };
    }
}

