/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.guitools.pcheckcombobox;

import de.p2tools.p2lib.guitools.pcheckcombobox.P2CheckBox;
import de.p2tools.p2lib.tools.P2Exception;
import de.p2tools.p2lib.tools.P2StringUtils;
import java.util.ArrayList;
import java.util.Optional;
import javafx.beans.property.BooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.CustomMenuItem;
import javafx.scene.control.SplitMenuButton;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseButton;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;

public class P2CheckComboBox
extends HBox {
    private final SplitMenuButton menuButton = new SplitMenuButton();
    private final ObservableList<String> items = FXCollections.observableArrayList();
    private final ArrayList<P2CheckBox> arrayList = new ArrayList();
    private String emptyText = "";

    public P2CheckComboBox() {
        this.init();
    }

    public void addItem(String item, String toolTip, BooleanProperty property) {
        Optional<String> otp = this.items.stream().filter(p -> p.equals(item)).findAny();
        if (otp.isPresent()) {
            P2Exception.throwPException(912032014, "Item exists already");
            return;
        }
        this.items.add(item);
        this.add(item, "", toolTip, property);
        this.setTitle();
    }

    public void addItem(String item, String shortText, String toolTip, BooleanProperty property) {
        Optional<String> otp = this.items.stream().filter(p -> p.equals(item)).findAny();
        if (otp.isPresent()) {
            P2Exception.throwPException(912032014, "Item exists already");
            return;
        }
        this.items.add(item);
        this.add(item, shortText, toolTip, property);
        this.setTitle();
    }

    public final void setTooltip(Tooltip value) {
        this.menuButton.setTooltip(value);
    }

    public final void setEmptyText(String value) {
        this.emptyText = value;
    }

    private void add(String item, String shortText, String toolTip, BooleanProperty property) {
        P2CheckBox cb = new P2CheckBox("Item ");
        cb.selectedProperty().bindBidirectional(property);
        cb.setText(item);
        cb.setShortText(shortText);
        cb.setTooltip(new Tooltip(toolTip));
        this.addListener(cb);
        CustomMenuItem cmi = new CustomMenuItem(cb);
        cmi.setHideOnClick(false);
        this.menuButton.getItems().add(cmi);
    }

    private void addListener(P2CheckBox checkBox) {
        this.arrayList.add(checkBox);
        checkBox.selectedProperty().addListener((ObservableValue<? super T> observable2, ? super T oldValue, ? super T newValue) -> this.setTitle());
    }

    private void setTitle() {
        ArrayList<String> list = new ArrayList<String>();
        this.arrayList.stream().filter(ch -> ch.isSelected()).forEach(ch -> list.add(ch.getResText()));
        if (list.isEmpty()) {
            this.menuButton.setText(this.emptyText);
        } else {
            this.menuButton.setText(P2StringUtils.appendList(list, ", "));
        }
    }

    private void init() {
        HBox.setHgrow(this.menuButton, Priority.ALWAYS);
        this.menuButton.setMaxWidth(Double.MAX_VALUE);
        this.getChildren().addAll((Node[])new Node[]{this.menuButton});
        this.menuButton.setOnMouseClicked(m -> {
            if (m.getButton().equals((Object)MouseButton.PRIMARY) && m.getClickCount() == 2) {
                this.arrayList.stream().forEach(ch -> ch.setSelected(false));
            }
        });
        this.menuButton.setOnMousePressed(event -> {
            if (event.getButton().equals((Object)MouseButton.PRIMARY) && event.getClickCount() == 1) {
                if (this.menuButton.isShowing()) {
                    this.menuButton.hide();
                } else {
                    this.menuButton.show();
                }
            }
        });
    }
}

