/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.guitools;

import de.p2tools.p2lib.guitools.P2NumberStringConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import javafx.beans.binding.Bindings;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.ObservableList;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.input.MouseButton;

public class P2ComboBoxInteger
extends ComboBox<String> {
    public final int MAX_ELEMENTS = 15;
    private int maxElements = 15;
    private StringProperty selValueStringProperty = null;
    private ObservableList<String> itemsList = null;
    private final Locale locale = Locale.GERMAN;

    public P2ComboBoxInteger() {
        this.setEditable(true);
    }

    public void init(ObservableList<String> dataList) {
        this.itemsList = dataList;
        this.setCombo();
    }

    public void init(ObservableList<String> dataList, IntegerProperty property) {
        this.selValueStringProperty = this.getStringProperty(property);
        this.itemsList = dataList;
        this.selectElement(this.selValueStringProperty.getValueSafe());
        this.setCombo();
    }

    public void init(ObservableList<String> dataList, String init, IntegerProperty property) {
        this.selValueStringProperty = this.getStringProperty(property);
        this.itemsList = dataList;
        this.selectElement(init);
        this.setCombo();
    }

    public void bindSelValueProperty(IntegerProperty property) {
        this.unbind();
        this.selValueStringProperty = this.getStringProperty(property);
        this.bind();
    }

    public void unbindSelValueProperty() {
        this.unbind();
        this.selValueStringProperty = null;
        this.selectElement("");
    }

    public String getSelValue() {
        String s = (String)this.getSelectionModel().getSelectedItem();
        if (s == null) {
            s = "";
        }
        return s;
    }

    public ReadOnlyObjectProperty<String> getSelValueProperty() {
        ReadOnlyObjectProperty<String> s = this.getSelectionModel().selectedItemProperty();
        return s;
    }

    public void selectElement(String element) {
        this.setValue(element);
    }

    public int getMaxElements() {
        return this.maxElements;
    }

    public void setMaxElements(int maxElements) {
        this.maxElements = maxElements;
    }

    private void setCombo() {
        if (this.itemsList == null) {
            return;
        }
        this.reduceList();
        Collections.sort(this.itemsList);
        this.setItems(this.itemsList);
        this.getSelectionModel().selectedItemProperty().addListener((observable2, oldValue, newValue) -> {
            if (newValue != null && !this.itemsList.contains(newValue)) {
                this.itemsList.add(0, (String)newValue);
                this.setValue(newValue);
            }
        });
        this.getEditor().setOnMousePressed(m -> {
            if (m.getButton().equals((Object)MouseButton.SECONDARY)) {
                this.getEditor().setContextMenu(this.getMenu());
            }
        });
        this.itemsList.addListener(c -> {
            if (this.itemsList.size() == 1) {
                this.getSelectionModel().selectFirst();
            }
        });
        this.bind();
    }

    private void bind() {
        if (this.selValueStringProperty == null) {
            return;
        }
        this.valueProperty().bindBidirectional(this.selValueStringProperty);
    }

    private void unbind() {
        if (this.selValueStringProperty == null) {
            this.setValue("");
            return;
        }
        this.valueProperty().unbindBidirectional(this.selValueStringProperty);
    }

    private void delList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("");
        this.itemsList.setAll((Collection<String>)list);
        this.getSelectionModel().selectFirst();
    }

    private void reduceList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("");
        this.itemsList.stream().forEach(d -> {
            if (!list.contains(d) && list.size() < this.maxElements) {
                list.add((String)d);
            }
        });
        this.itemsList.setAll((Collection<String>)list);
    }

    private ContextMenu getMenu() {
        ContextMenu contextMenu = new ContextMenu();
        MenuItem delEntries = new MenuItem("Eintr\u00e4ge l\u00f6schen");
        delEntries.setOnAction(a -> this.delList());
        contextMenu.getItems().addAll((MenuItem[])new MenuItem[]{delEntries});
        return contextMenu;
    }

    private StringProperty getStringProperty(IntegerProperty ip) {
        if (ip == null) {
            return null;
        }
        SimpleStringProperty sp = new SimpleStringProperty();
        sp.setValue(String.valueOf(ip.getValue()));
        this.bind(ip, sp);
        return sp;
    }

    private void bind(IntegerProperty ip, StringProperty sp) {
        Bindings.bindBidirectional((Property<String>)sp, ip, new P2NumberStringConverter(this));
    }
}

