/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.guitools;

import de.p2tools.p2lib.P2ProgIcons;
import de.p2tools.p2lib.mediathek.filter.FilterCheckRegEx;
import java.util.function.BooleanSupplier;
import javafx.beans.binding.Bindings;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.HBox;

public class P2CboString
extends ComboBox<P2CboLabel> {
    public static final int MAX_FILTER_HISTORY = 15;
    private final ObservableList<String> storedFilterList;
    private final ObservableList<P2CboLabel> itemList = FXCollections.observableArrayList(new P2CboLabel(""));
    private final StringProperty strSearchProperty;
    private final BooleanSupplier doSomething;

    public P2CboString(ObservableList<String> storedFilterList, StringProperty strSearchProperty) {
        this.storedFilterList = storedFilterList;
        this.strSearchProperty = strSearchProperty;
        this.doSomething = () -> true;
        this.start();
    }

    public P2CboString(ObservableList<String> storedFilterList, StringProperty strSearchProperty, BooleanSupplier doSomething) {
        this.storedFilterList = storedFilterList;
        this.strSearchProperty = strSearchProperty;
        this.doSomething = doSomething;
        this.start();
    }

    public void addValue(String add) {
        if (add.isEmpty()) {
            return;
        }
        this.getEditor().setText(add);
    }

    public StringProperty getStrSearchProperty() {
        return this.strSearchProperty;
    }

    public ObservableList<String> getStoredFilterList() {
        return this.storedFilterList;
    }

    private void start() {
        this.storedFilterList.forEach(s -> {
            P2CboLabel tf;
            if (!s.isEmpty() && (tf = (P2CboLabel)this.itemList.stream().filter(pCboSearchLabel -> pCboSearchLabel.getText().equals(s)).findFirst().orElse(null)) == null) {
                this.itemList.add(new P2CboLabel((String)s));
            }
        });
        this.setItems(this.itemList);
        this.fillStoredList();
        this.setEditable(true);
        this.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.setVisibleRowCount(15);
        this.init();
    }

    private void init() {
        new FilterCheckRegEx(this.getEditor());
        this.getEditor().textProperty().addListener((observable2, oldValue, newValue) -> {
            if (newValue == null) {
                return;
            }
            if (!this.isShowing()) {
                this.addLastFilter((String)newValue);
            }
            this.strSearchProperty.setValue(this.getEditor().getText());
        });
        this.getSelectionModel().selectedItemProperty().addListener((observable2, oldValue, newValue) -> {
            if (this.isShowing() || newValue != null && newValue.getClass().equals(P2CboLabel.class) && !this.strSearchProperty.getValueSafe().equals(((P2CboLabel)newValue).getText())) {
                this.doSomething.getAsBoolean();
            }
        });
        this.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.doSomething.getAsBoolean();
            }
        });
        this.strSearchProperty.addListener((u, o, n) -> this.getEditor().setText(this.strSearchProperty.getValue()));
        this.getEditor().setText(this.strSearchProperty.getValue());
        this.setCellFactory(cell -> new ListCell<P2CboLabel>(){
            final Button btnDel = new Button();
            final HBox hBox = new HBox();
            final Label lblFilter = new Label();
            {
                this.btnDel.setGraphic(P2ProgIcons.ICON_BUTTON_DEL_SW.getImageView());
                this.btnDel.getStyleClass().add("buttonVerySmall");
                this.btnDel.visibleProperty().bind(Bindings.size(P2CboString.this.itemList).greaterThan(1));
                this.hBox.setPadding(new Insets(0.0));
                this.hBox.setAlignment(Pos.CENTER_LEFT);
                this.hBox.setSpacing(5.0);
                this.hBox.getChildren().addAll((Node[])new Node[]{this.btnDel, this.lblFilter});
            }

            @Override
            protected void updateItem(P2CboLabel searchLabel, boolean empty) {
                super.updateItem(searchLabel, empty);
                P2CboString.this.setVisibleRowCount(8);
                P2CboString.this.setVisibleRowCount(10);
                if (!empty && searchLabel != null) {
                    this.btnDel.setOnMousePressed(m -> {
                        if (searchLabel.getText().isEmpty()) {
                            if (P2CboString.this.itemList.size() > 1) {
                                P2CboString.this.itemList.remove(1, P2CboString.this.itemList.size());
                            }
                        } else {
                            P2CboString.this.itemList.remove(searchLabel);
                        }
                        P2CboString.this.getSelectionModel().select(0);
                        P2CboString.this.fillStoredList();
                    });
                    this.lblFilter.textProperty().bind(searchLabel.textProperty());
                    this.setGraphic(this.hBox);
                } else {
                    this.setGraphic(null);
                }
            }
        });
    }

    private synchronized void addLastFilter(String addF) {
        P2CboLabel tf;
        this.getSelectionModel().clearSelection();
        P2CboLabel addFilter = new P2CboLabel(addF);
        if (addFilter.getText().isEmpty()) {
            return;
        }
        if (this.getItems().size() <= 1) {
            this.getItems().add(addFilter);
            return;
        }
        P2CboLabel tmp = (P2CboLabel)this.getItems().get(1);
        if (addF.contains(tmp.getText())) {
            tmp.setText(addF);
        }
        if ((tf = (P2CboLabel)this.itemList.stream().filter(pCboSearchLabel -> pCboSearchLabel.getText().equals(addF)).findFirst().orElse(null)) == null) {
            while (this.itemList.size() > 15) {
                this.itemList.remove(this.itemList.size() - 1);
            }
            this.itemList.add(1, addFilter);
        } else {
            this.itemList.remove(tf);
            this.itemList.add(1, tf);
        }
        this.fillStoredList();
    }

    private void fillStoredList() {
        this.storedFilterList.clear();
        this.itemList.forEach(s -> this.storedFilterList.add(s.toString()));
    }

    static class P2CboLabel
    extends Label
    implements Comparable<P2CboLabel> {
        public P2CboLabel(String value) {
            this.setText(value);
        }

        @Override
        public String toString() {
            return this.getText();
        }

        @Override
        public int compareTo(P2CboLabel arg0) {
            return this.getText().compareTo(arg0.getText());
        }
    }
}

