/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.dialogs.accordion;

import de.p2tools.p2lib.tools.P2Exception;
import java.util.Collection;
import javafx.beans.property.IntegerProperty;
import javafx.collections.ObservableList;
import javafx.scene.control.Accordion;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.VBox;

public class P2Accordion {
    public static void initAccordionPane(Accordion accordion, IntegerProperty selectedPane) {
        accordion.expandedPaneProperty().addListener((observable2, oldValue, newValue) -> {
            TitledPane titledPane = accordion.getExpandedPane();
            ObservableList<TitledPane> accList = accordion.getPanes();
            for (int i = 0; i < accList.size(); ++i) {
                if (!((TitledPane)accList.get(i)).equals(titledPane)) continue;
                selectedPane.setValue(i);
            }
        });
    }

    public static void setAccordionPane(Accordion accordion, IntegerProperty selectedPane) {
        if (selectedPane.get() < 0 && accordion.getPanes().size() == 1) {
            accordion.setExpandedPane((TitledPane)accordion.getPanes().get(0));
            return;
        }
        if (selectedPane.get() < 0) {
            return;
        }
        if (selectedPane.get() >= accordion.getPanes().size()) {
            P2Exception.throwPException(974125035, "setAccordionPane");
        }
        int sel = selectedPane.get();
        accordion.setExpandedPane((TitledPane)accordion.getPanes().get(sel));
    }

    public static void setAccordion(boolean setAcc, Accordion accordion, VBox noAccordion, ScrollPane scrollPane, Collection<TitledPane> titledPanes, IntegerProperty selectedPane) {
        if (setAcc) {
            noAccordion.getChildren().clear();
            accordion.getPanes().addAll(titledPanes);
            scrollPane.setContent(accordion);
            P2Accordion.setAccordionPane(accordion, selectedPane);
        } else {
            accordion.getPanes().clear();
            noAccordion.getChildren().addAll(titledPanes);
            titledPanes.stream().forEach(titledPane -> titledPane.setExpanded(true));
            scrollPane.setContent(noAccordion);
        }
    }
}

