/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.dialogs;

import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.dialogs.dialog.P2DialogExtra;
import de.p2tools.p2lib.guitools.P2ColumnConstraints;
import de.p2tools.p2lib.tools.P2InfoFactory;
import de.p2tools.p2lib.tools.duration.P2Duration;
import de.p2tools.p2lib.tools.log.P2Log;
import java.util.ArrayList;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.geometry.Insets;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.util.Duration;

public class ProgInfoDialog
extends P2DialogExtra {
    private final Button btnOk = new Button("_Ok");
    private final Button btnGc = new Button("_Speicher aufr\u00e4umen");
    private final Button btnDuration = new Button("_Laufzeiten ausgeben");
    private final ProgressBar progressBar = new ProgressBar();
    private final Label lblMemInfo = new Label("");
    private final Runtime rt = Runtime.getRuntime();
    private static final int MEGABYTE = 1000000;

    public ProgInfoDialog(boolean showDialog) {
        super(P2LibConst.primaryStage, null, "Speicherverbrauch des Programms", false, false, P2DialogExtra.DECO.NO_BORDER);
        this.addOkButton(this.btnOk);
        this.init(showDialog);
    }

    @Override
    protected void make() {
        String line = "<==/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\==>";
        this.btnOk.setOnAction(a -> this.close());
        this.btnGc.setOnAction(a -> System.gc());
        this.btnDuration.setOnAction(a -> {
            ArrayList<String> list = P2Duration.getCounter();
            list.add(0, "<==/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\==>");
            list.add("<==/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\/\\==>");
            list.add(" ");
            list.add(" ");
            P2Log.sysLog(list);
        });
        GridPane gridPane = new GridPane();
        gridPane.setHgap(5.0);
        gridPane.setVgap(5.0);
        gridPane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        int row = 0;
        Text text = new Text("Java Informationen");
        text.setFont(Font.font(null, FontWeight.BOLD, 15.0));
        text.getStyleClass().add("downloadGuiMediaText");
        gridPane.add(text, 0, row, 3, 1);
        gridPane.add(new Label("Version:"), 0, ++row);
        gridPane.add(new Label(System.getProperty("java.version")), 1, row, 2, 1);
        gridPane.add(new Label("Type:"), 0, ++row);
        Object strVmType = System.getProperty("java.vm.name");
        strVmType = (String)strVmType + " (" + System.getProperty("java.vendor") + ")";
        gridPane.add(new Label((String)strVmType), 1, row, 2, 1);
        gridPane.add(new Label(" "), 0, ++row);
        text = new Text("Speicherverbrauch des Programms");
        text.setFont(Font.font(null, FontWeight.BOLD, 15.0));
        text.getStyleClass().add("downloadGuiMediaText");
        gridPane.add(text, 0, ++row, 3, 1);
        this.progressBar.setMaxWidth(Double.MAX_VALUE);
        this.progressBar.setMinWidth(10.0);
        this.lblMemInfo.setMaxWidth(Double.NEGATIVE_INFINITY);
        gridPane.add(this.btnGc, 0, ++row);
        gridPane.add(this.progressBar, 1, row);
        gridPane.add(this.lblMemInfo, 2, row);
        gridPane.add(new Label(" "), 0, ++row);
        text = new Text("Laufzeiten des Programms");
        text.setFont(Font.font(null, FontWeight.BOLD, 15.0));
        text.getStyleClass().add("downloadGuiMediaText");
        gridPane.add(text, 0, ++row, 3, 1);
        gridPane.add(this.btnDuration, 0, ++row);
        gridPane.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{P2ColumnConstraints.getCcPrefSize(), P2ColumnConstraints.getCcComputedSizeAndHgrow(), P2ColumnConstraints.getCcPrefSize()});
        this.getVBoxCont().getChildren().add(gridPane);
        Timeline timeline = new Timeline(new KeyFrame(Duration.millis(1000.0), ae -> this.getMem(), new KeyValue[0]));
        timeline.setCycleCount(-1);
        timeline.setDelay(Duration.seconds(1.0));
        timeline.play();
    }

    private void getMem() {
        long maxMem = P2InfoFactory.getOs() == P2InfoFactory.OperatingSystemType.LINUX ? this.rt.totalMemory() : this.rt.maxMemory();
        long totalMemory = this.rt.totalMemory();
        long freeMemory = this.rt.freeMemory();
        long usedMem = totalMemory - freeMemory;
        long used = usedMem / 1000000L;
        long total = maxMem / 1000000L;
        double usedD = 1.0 * (double)usedMem / (double)totalMemory;
        this.progressBar.setProgress(usedD);
        String info = used + " von " + total + "MB";
        this.lblMemInfo.setText(info);
    }
}

