/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.dialogs;

import de.p2tools.p2lib.P2ProgIcons;
import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.dialogs.P2DirFileChooser;
import java.util.Optional;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.Stage;

public class P2DialogFileChooser
extends P2Alert {
    public static String showFileChooser(Stage stage, String title, String header, String content, boolean dir) {
        return P2DialogFileChooser.showFileChooser(stage, title, header, content, dir, true, "");
    }

    public static String showFileChooser(Stage stage, String title, String header, String content, boolean dir, boolean txtArea, String startFile) {
        Dialog dialog = new Dialog();
        if (stage != null) {
            dialog.initOwner(stage);
        }
        dialog.setTitle(title);
        dialog.setHeaderText(header);
        dialog.setResizable(true);
        dialog.getDialogPane().setMinHeight(Double.NEGATIVE_INFINITY);
        GridPane grid = new GridPane();
        grid.setHgap(10.0);
        grid.setVgap(10.0);
        grid.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        if (txtArea) {
            TextArea textArea = new TextArea(content);
            textArea.setEditable(false);
            textArea.setWrapText(true);
            GridPane.setVgrow(textArea, Priority.ALWAYS);
            GridPane.setHgrow(textArea, Priority.ALWAYS);
            grid.add(textArea, 0, 0, 2, 1);
        } else {
            Label label = new Label(content);
            label.setWrapText(true);
            GridPane.setVgrow(label, Priority.ALWAYS);
            GridPane.setHgrow(label, Priority.ALWAYS);
            grid.add(label, 0, 0, 2, 1);
        }
        TextField txtFile = new TextField(startFile);
        GridPane.setVgrow(txtFile, Priority.ALWAYS);
        Button btnDest = new Button("");
        btnDest.setGraphic(P2ProgIcons.IMAGE_FILE_OPEN.getImageView());
        btnDest.setOnAction(event -> {
            if (dir) {
                P2DirFileChooser.DirChooser(stage, txtFile);
            } else {
                P2DirFileChooser.FileChooserOpenFile(stage, txtFile);
            }
        });
        grid.add(txtFile, 0, 1);
        grid.add(btnDest, 1, 1);
        ColumnConstraints c0 = new ColumnConstraints();
        grid.getColumnConstraints().addAll((ColumnConstraints[])new ColumnConstraints[]{c0});
        c0.setMinWidth(Double.NEGATIVE_INFINITY);
        c0.setHgrow(Priority.ALWAYS);
        dialog.getDialogPane().setContent(grid);
        ButtonType btnOk = new ButtonType("Ok", ButtonBar.ButtonData.OK_DONE);
        ButtonType btnCancel = new ButtonType("Abbrechen", ButtonBar.ButtonData.CANCEL_CLOSE);
        dialog.getDialogPane().getButtonTypes().addAll((ButtonType[])new ButtonType[]{btnOk, btnCancel});
        Node okBtn = dialog.getDialogPane().lookupButton(btnOk);
        okBtn.setDisable(txtFile.getText().isEmpty());
        txtFile.textProperty().addListener((observable2, oldValue, newValue) -> okBtn.setDisable(newValue.trim().isEmpty()));
        Optional result = dialog.showAndWait();
        if (result.isPresent() && result.get() == btnCancel) {
            return "";
        }
        return txtFile.getText();
    }
}

