/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.configfile.pdata;

import de.p2tools.p2lib.configfile.pdata.P2Configs;
import de.p2tools.p2lib.tools.GermanStringSorter;
import java.util.HashMap;
import java.util.LinkedList;

public class P2Config {
    private static final HashMap<String, P2Configs> HASHMAP = new HashMap();

    public static P2Configs get(String key) {
        return HASHMAP.get(key);
    }

    public static synchronized void check(P2Configs p2Configs, int min, int max) {
        int v = p2Configs.getInt();
        if (v < min || v > max) {
            p2Configs.setValue(p2Configs.getInitValue());
        }
    }

    public static synchronized P2Configs addNewKey(String key) {
        P2Configs c = new P2Configs(key);
        HASHMAP.put(key, c);
        return c;
    }

    public static synchronized P2Configs addNewKey(String key, String value) {
        P2Configs c = new P2Configs(key, value == null ? "" : value);
        HASHMAP.put(key, c);
        return c;
    }

    public static synchronized P2Configs addNewKey(String key, int value) {
        P2Configs c = new P2Configs(key, value);
        HASHMAP.put(key, c);
        return c;
    }

    public static synchronized String[][] getAll() {
        LinkedList<String[]> list = new LinkedList<String[]>();
        for (P2Configs c : HASHMAP.values()) {
            list.add(new String[]{c.getKey(), c.getActValue().getValueSafe()});
        }
        P2Config.listSort(list, 0);
        return (String[][])list.toArray((T[])new String[0][]);
    }

    private static void listSort(LinkedList<String[]> list, int index) {
        GermanStringSorter sorter = GermanStringSorter.getInstance();
        if (list == null) {
            return;
        }
        for (int i = 1; i < list.size(); ++i) {
            String str2;
            String str1;
            for (int k = i; k > 0 && sorter.compare(str1 = list.get(k - 1)[index], str2 = list.get(k)[index]) > 0; --k) {
                list.add(k - 1, list.remove(k));
            }
        }
    }
}

