/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.configfile;

import de.p2tools.p2lib.configfile.ConfigBackupFile;
import de.p2tools.p2lib.configfile.ConfigFile;
import de.p2tools.p2lib.configfile.ConfigWrite;
import de.p2tools.p2lib.tools.log.P2Log;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ConfigWriteFile {
    private ConfigWriteFile() {
    }

    public static boolean writeConfigFileZip(Path path, ArrayList<ConfigFile> cFileList) {
        boolean ret = true;
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            new ConfigBackupFile(path).backupConfigFile();
            ZipOutputStream zipOut = new ZipOutputStream(new FileOutputStream(path.toFile()));
            for (ConfigFile cf : cFileList) {
                ZipEntry zipEntry = new ZipEntry(Path.of(cf.getFilePath(), new String[0]).getFileName().toString());
                zipOut.putNextEntry(zipEntry);
                ConfigWrite configWrite = new ConfigWrite(cf);
                if (!configWrite.write(zipOut)) {
                    ret = false;
                    break;
                }
                zipOut.closeEntry();
            }
            zipOut.close();
        }
        catch (Exception ex) {
            P2Log.errorLog(784512589, ex);
            ret = false;
        }
        return ret;
    }

    public static boolean writeConfigFile(ConfigFile cFile) {
        ArrayList<ConfigFile> list = new ArrayList<ConfigFile>();
        list.add(cFile);
        return ConfigWriteFile.writeConfigFile(list);
    }

    public static boolean writeConfigFile(ArrayList<ConfigFile> cFileList) {
        boolean ret = true;
        try {
            for (ConfigFile cf : cFileList) {
                OutputStream outputStream2;
                ConfigWrite configWrite;
                Files.createDirectories(Path.of(cf.getFilePath(), new String[0]).getParent(), new FileAttribute[0]);
                if (cf.isBackup()) {
                    new ConfigBackupFile(Path.of(cf.getFilePath(), new String[0])).backupConfigFile();
                }
                if ((configWrite = new ConfigWrite(cf)).write(outputStream2 = Files.newOutputStream(Path.of(cf.getFilePath(), new String[0]), new OpenOption[0]))) continue;
                ret = false;
            }
        }
        catch (IOException ex) {
            P2Log.errorLog(602035789, ex);
            ret = false;
        }
        return ret;
    }
}

