/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.configfile;

import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.configfile.ConfigFile;
import de.p2tools.p2lib.configfile.config.Config;
import de.p2tools.p2lib.configfile.config.Config_comment;
import de.p2tools.p2lib.configfile.config.Config_pData;
import de.p2tools.p2lib.configfile.config.Config_pDataList;
import de.p2tools.p2lib.configfile.configlist.ConfigList;
import de.p2tools.p2lib.configfile.pdata.P2Data;
import de.p2tools.p2lib.configfile.pdata.P2DataList;
import de.p2tools.p2lib.tools.log.P2Log;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

class ConfigWrite {
    private final ConfigFile configFile;
    private OutputStreamWriter outputStreamWriter = null;
    private XMLStreamWriter xmlStreamWriter = null;

    ConfigWrite(ConfigFile configFile) {
        this.configFile = configFile;
    }

    synchronized boolean write(OutputStream outputStream2) {
        try {
            this.xmlWriteStart(outputStream2);
            this.xmlDataWrite();
            this.xmlWriteEnd();
            return true;
        }
        catch (Exception ex) {
            P2Log.errorLog(912014085, ex);
            return false;
        }
    }

    private void xmlWriteStart(OutputStream outputStream2) throws XMLStreamException {
        P2Log.sysLog("Start Schreiben nach: " + this.configFile.getFilePath());
        this.outputStreamWriter = new OutputStreamWriter(outputStream2, StandardCharsets.UTF_8);
        XMLOutputFactory outFactory = XMLOutputFactory.newInstance();
        this.xmlStreamWriter = outFactory.createXMLStreamWriter(this.outputStreamWriter);
        this.xmlStreamWriter.writeStartDocument(StandardCharsets.UTF_8.name(), "1.0");
        this.xmlStreamWriter.writeCharacters(P2LibConst.LINE_SEPARATOR);
        this.xmlStreamWriter.writeStartElement(this.configFile.getXmlStart());
        this.xmlStreamWriter.writeCharacters(P2LibConst.LINE_SEPARATOR);
    }

    private void xmlDataWrite() throws XMLStreamException {
        for (P2Data p2Data : this.configFile.getpData()) {
            this.xmlStreamWriter.writeCharacters(P2LibConst.LINE_SEPARATORx2);
            this.xmlStreamWriter.writeComment(p2Data.getComment());
            this.xmlStreamWriter.writeCharacters(P2LibConst.LINE_SEPARATOR);
            this.write(p2Data, 0);
        }
        for (P2DataList cl : this.configFile.getpDataList()) {
            this.xmlStreamWriter.writeCharacters(P2LibConst.LINE_SEPARATOR);
            this.xmlStreamWriter.writeComment(cl.getComment());
            this.write(cl, 0);
        }
        this.xmlStreamWriter.writeCharacters(P2LibConst.LINE_SEPARATORx2);
    }

    private void xmlWriteEnd() throws XMLStreamException {
        this.xmlStreamWriter.writeEndElement();
        this.xmlStreamWriter.writeEndDocument();
        this.xmlStreamWriter.flush();
        P2Log.sysLog("geschrieben!");
    }

    private void write(Object o, int tab) throws XMLStreamException {
        if (o instanceof P2Data) {
            this.writePData((P2Data)o, tab);
        } else if (o instanceof P2DataList) {
            this.writePDataList((P2DataList)o, tab);
        } else if (o instanceof Config_pDataList) {
            this.writeConfigPDataList((Config_pDataList)o, tab);
        } else if (o instanceof Config_pData) {
            this.writeConfigPData((Config_pData)o, tab);
        } else if (o instanceof Config_comment) {
            this.writeComment((Config)o, tab);
        } else if (o instanceof ConfigList) {
            this.writeConfigList((ConfigList)o, tab);
        } else if (o instanceof Config) {
            this.writeConfig((Config)o, tab);
        } else {
            P2Log.sysLog("Fehler beim Schreiben von: " + o.getClass().toString());
        }
    }

    private void writePData(P2Data p2Data, int tab) throws XMLStreamException {
        String xmlName = p2Data.getTag().split(":")[0];
        this.writeTab(tab++);
        this.xmlStreamWriter.writeStartElement(xmlName);
        this.xmlStreamWriter.writeCharacters(P2LibConst.LINE_SEPARATOR);
        for (Config config : p2Data.getConfigsArr()) {
            this.write(config, tab);
        }
        this.writeTab(--tab);
        this.xmlStreamWriter.writeEndElement();
        this.xmlStreamWriter.writeCharacters(P2LibConst.LINE_SEPARATOR);
    }

    private void writePDataList(P2DataList p2DataList, int tab) throws XMLStreamException {
        String xmlName = p2DataList.getTag().split(":")[0];
        this.xmlStreamWriter.writeCharacters(P2LibConst.LINE_SEPARATOR);
        this.writeTab(tab++);
        this.xmlStreamWriter.writeStartElement(xmlName);
        this.xmlStreamWriter.writeCharacters(P2LibConst.LINE_SEPARATOR);
        for (Object configsData : p2DataList) {
            this.write(configsData, tab);
        }
        this.writeTab(--tab);
        this.xmlStreamWriter.writeEndElement();
        this.xmlStreamWriter.writeCharacters(P2LibConst.LINE_SEPARATOR);
    }

    private void writeConfigPDataList(Config_pDataList configPDataList, int tab) throws XMLStreamException {
        P2DataList list = configPDataList.getActValue();
        this.writePDataList(list, tab);
    }

    private void writeConfigPData(Config_pData configPData, int tab) throws XMLStreamException {
        P2Data p2Data = configPData.getActValue();
        this.writePData(p2Data, tab);
    }

    private void writeConfigList(ConfigList config, int tab) throws XMLStreamException {
        if (config.getActValue() != null && !config.getActValue().isEmpty()) {
            this.writeTab(tab++);
            this.xmlStreamWriter.writeStartElement(config.getKey().split(":")[0]);
            this.xmlStreamWriter.writeCharacters(P2LibConst.LINE_SEPARATOR);
            Object actValue = config.getActValue();
            int i = 0;
            Iterator iterator2 = actValue.iterator();
            while (iterator2.hasNext()) {
                Object o = iterator2.next();
                this.writeTab(tab);
                this.xmlStreamWriter.writeStartElement(config.getKey().split(":")[0] + "-" + ++i);
                this.xmlStreamWriter.writeCharacters(o.toString());
                this.xmlStreamWriter.writeEndElement();
                this.xmlStreamWriter.writeCharacters(P2LibConst.LINE_SEPARATOR);
            }
            this.writeTab(--tab);
            this.xmlStreamWriter.writeEndElement();
            this.xmlStreamWriter.writeCharacters(P2LibConst.LINE_SEPARATOR);
        }
    }

    private void writeComment(Config config, int tab) throws XMLStreamException {
        if (config.getActValue() == null) {
            return;
        }
        if (config.getActValueString().isEmpty()) {
            this.xmlStreamWriter.writeCharacters(P2LibConst.LINE_SEPARATOR);
        } else {
            this.writeTab(tab);
            this.xmlStreamWriter.writeCharacters(P2LibConst.LINE_SEPARATOR);
            this.xmlStreamWriter.writeComment("  " + config.getActValueString() + "  ");
            this.xmlStreamWriter.writeCharacters(P2LibConst.LINE_SEPARATOR);
        }
    }

    private void writeConfig(Config config, int tab) throws XMLStreamException {
        if (config.getActValue() != null && !config.getActValueString().isEmpty()) {
            this.writeTab(tab);
            this.xmlStreamWriter.writeStartElement(config.getKey().split(":")[0]);
            this.xmlStreamWriter.writeCharacters(config.getActValueString());
            this.xmlStreamWriter.writeEndElement();
            this.xmlStreamWriter.writeCharacters(P2LibConst.LINE_SEPARATOR);
        }
    }

    private void writeTab(int tab) throws XMLStreamException {
        for (int t = 0; t < tab; ++t) {
            this.xmlStreamWriter.writeCharacters("\t");
        }
    }
}

