/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.colordata;

import de.p2tools.p2lib.colordata.P2ColorDataProps;
import de.p2tools.p2lib.tools.P2ColorFactory;
import javafx.beans.property.ObjectProperty;
import javafx.scene.paint.Color;

public class P2ColorData
extends P2ColorDataProps {
    private static final int ODD_DIVIDER = 250;
    public static int ODD_DIV = 15;
    private final double DIV = 0.4;
    private final double DIV_DARK = 0.6;
    private String text = "";
    private int mark = 0;
    private String cssFont = "";
    private String cssFontBold = "";
    private String cssBackground = "";
    private String cssBackgroundAndSel = "";
    private String cssFont_ODD = "";
    private String cssFontBold_ODD = "";
    private String cssBackground_ODD = "";
    private String cssBackgroundAndSel_ODD = "";
    private boolean dark = false;
    private Color resetColorLight;
    private Color resetColorDark;

    public P2ColorData() {
        this.changeMyColor();
    }

    public P2ColorData(String key, Color color, Color colorDark) {
        this.setKey(key);
        super.setColorLight(color);
        super.setColorDark(colorDark);
        this.resetColorLight = color;
        this.resetColorDark = colorDark;
        this.setUse(true);
        this.text = "";
        this.changeMyColor();
    }

    public P2ColorData(String key, Color color, Color colorDark, boolean use, String text) {
        this.setKey(key);
        super.setColorLight(color);
        super.setColorDark(colorDark);
        this.resetColorLight = color;
        this.resetColorDark = colorDark;
        this.setUse(use);
        this.text = text;
        this.changeMyColor();
    }

    @Override
    public int compareTo(P2ColorData data) {
        if (data == null) {
            return -1;
        }
        return this.getKey().compareTo(data.getKey());
    }

    public void setColorTheme(boolean dark) {
        this.dark = dark;
        this.changeMyColor();
    }

    public Color getColor() {
        if (this.dark) {
            return this.getColorDark();
        }
        return this.getColorLight();
    }

    public void setColor(Color newColor) {
        if (this.dark) {
            super.setColorDark(newColor);
        } else {
            super.setColorLight(newColor);
        }
        this.changeMyColor();
    }

    public ObjectProperty<Color> colorProperty() {
        if (this.dark) {
            return this.colorDarkProperty();
        }
        return this.colorLightProperty();
    }

    public Color getResetColorDark() {
        return this.resetColorDark;
    }

    public Color getResetColorLight() {
        return this.resetColorLight;
    }

    public Color getResetColor() {
        return this.dark ? this.resetColorDark : this.resetColorLight;
    }

    @Override
    public void setColorLight(Color newColor) {
        super.setColorLight(newColor);
        this.changeMyColor();
    }

    @Override
    public void setColorDark(Color newColor) {
        super.setColorDark(newColor);
        this.changeMyColor();
    }

    public void resetColor() {
        if (this.dark) {
            super.setColorDark(this.resetColorDark);
        } else {
            super.setColorLight(this.resetColorLight);
        }
        this.changeMyColor();
    }

    public void resetColorDarkLight() {
        super.setColorDark(this.resetColorDark);
        super.setColorLight(this.resetColorLight);
        this.changeMyColor();
    }

    public String getText() {
        return this.text;
    }

    public int getMark() {
        return this.mark;
    }

    public void setMark(int mark) {
        this.mark = mark;
    }

    public String getCssFont() {
        return this.cssFont;
    }

    public String getCssFontBold() {
        return this.cssFontBold;
    }

    public String getCssBackground() {
        return this.cssBackground;
    }

    public String getCssBackgroundAndSel() {
        return this.cssBackgroundAndSel;
    }

    public String getCssFont_ODD() {
        return this.cssFont_ODD;
    }

    public String getCssFontBold_ODD() {
        return this.cssFontBold_ODD;
    }

    public String getCssBackground_ODD() {
        return this.cssBackground_ODD;
    }

    public String getCssBackgroundAndSel_ODD() {
        return this.cssBackgroundAndSel_ODD;
    }

    public String getCssFont(boolean odd) {
        return odd ? this.cssFont_ODD : this.cssFont;
    }

    public String getCssFontBold(boolean odd) {
        return odd ? this.cssFontBold_ODD : this.cssFontBold;
    }

    public String getCssBackground(boolean odd) {
        return odd ? this.cssBackground_ODD : this.cssBackground;
    }

    public String getCssBackgroundAndSel(boolean odd) {
        return odd ? this.cssBackgroundAndSel_ODD : this.cssBackgroundAndSel;
    }

    public String getColorSelectedToWeb() {
        return "#" + P2ColorFactory.getColorToHex(this.dark ? this.getColorDark() : this.getColorLight());
    }

    public String getColorSelectedToWeb(boolean odd) {
        if (odd) {
            return "#" + P2ColorFactory.getColorToHex(this.getColorOdd(this.dark ? this.getColorDark() : this.getColorLight()));
        }
        return "#" + P2ColorFactory.getColorToHex(this.dark ? this.getColorDark() : this.getColorLight());
    }

    public String getColorLightToWeb() {
        return "#" + P2ColorFactory.getColorToHex(this.getColorLight());
    }

    public String getColorDarkToWeb() {
        return "#" + P2ColorFactory.getColorToHex(this.getColorDark());
    }

    public String getColorDarkerToWeb() {
        return "#" + P2ColorFactory.getColorToHex(this.dark ? this.getBrighterColor(this.getColorDark()) : this.getDarkerColor(this.getColorLight()));
    }

    private Color getDarkerColor(Color color) {
        double blue;
        double green;
        double red;
        double min = color.getRed() < color.getGreen() ? color.getRed() : color.getGreen();
        min = min < color.getBlue() ? min : color.getBlue();
        double change = 0.99 * (min = min < 0.4 ? min : 0.4);
        if (change > 0.2) {
            red = color.getRed() - change;
            green = color.getGreen() - change;
            blue = color.getBlue() - change;
        } else {
            red = color.getRed() > 0.4 ? color.getRed() - 0.4 : 0.0;
            green = color.getGreen() > 0.4 ? color.getGreen() - 0.4 : 0.0;
            blue = color.getBlue() > 0.4 ? color.getBlue() - 0.4 : 0.0;
        }
        Color c = new Color(red, green, blue, color.getOpacity());
        return c;
    }

    private Color getBrighterColor(Color color) {
        double blue;
        double green;
        double red;
        double max = color.getRed() > color.getGreen() ? color.getRed() : color.getGreen();
        max = max > color.getBlue() ? max : color.getBlue();
        max = max > 0.6 ? max : 0.6;
        double change = 1.0 - max;
        if ((change = 0.99 * change) > 0.2) {
            red = color.getRed() + change;
            green = color.getGreen() + change;
            blue = color.getBlue() + change;
        } else {
            red = color.getRed() < 0.6 ? color.getRed() + 0.4 : 1.0;
            green = color.getGreen() < 0.6 ? color.getGreen() + 0.4 : 1.0;
            blue = color.getBlue() < 0.6 ? color.getBlue() + 0.4 : 1.0;
        }
        Color c = new Color(red, green, blue, color.getOpacity());
        return c;
    }

    private void changeMyColor() {
        this.cssFont = ("-fx-text-fill: " + this.getColorSelectedToWeb() + ";").intern();
        this.cssFontBold = ("-fx-font-weight: bold; -fx-text-fill: " + this.getColorSelectedToWeb() + ";").intern();
        this.cssBackground = ("-fx-control-inner-background: " + this.getColorSelectedToWeb() + ";").intern();
        this.cssBackgroundAndSel = ("-fx-selection-bar: " + this.getColorSelectedToWeb() + "; -fx-selection-bar-non-focused: " + this.getColorSelectedToWeb() + ";").intern();
        this.cssFont_ODD = ("-fx-text-fill: " + this.getColorSelectedToWeb(true) + ";").intern();
        this.cssFontBold_ODD = ("-fx-font-weight: bold; -fx-text-fill: " + this.getColorSelectedToWeb(true) + ";").intern();
        this.cssBackground_ODD = ("-fx-control-inner-background: " + this.getColorSelectedToWeb(true) + ";").intern();
        this.cssBackgroundAndSel_ODD = ("-fx-selection-bar: " + this.getColorSelectedToWeb(true) + "; -fx-selection-bar-non-focused: " + this.getColorSelectedToWeb(true) + ";").intern();
    }

    private Color getColorOdd(Color c) {
        double odd = 1.0 * (double)ODD_DIV / 250.0;
        double ODD_1_DIV = 1.0 - odd;
        if (c.getRed() < ODD_1_DIV && c.getGreen() < ODD_1_DIV && c.getBlue() < ODD_1_DIV) {
            return new Color(c.getRed() + odd, c.getGreen() + odd, c.getBlue() + odd, c.getOpacity());
        }
        if (c.getRed() > odd && c.getGreen() > odd && c.getBlue() > odd) {
            return new Color(c.getRed() - odd, c.getGreen() - odd, c.getBlue() - odd, c.getOpacity());
        }
        return new Color(c.getRed() < ODD_1_DIV ? c.getRed() + odd : 1.0, c.getGreen() < ODD_1_DIV ? c.getGreen() + odd : 1.0, c.getBlue() < ODD_1_DIV ? c.getBlue() + odd : 1.0, c.getOpacity());
    }
}

