/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib.checkforactinfos;

import de.p2tools.p2lib.alert.P2Alert;
import de.p2tools.p2lib.checkforactinfos.FoundAllFiles;
import de.p2tools.p2lib.checkforactinfos.FoundSearchDataDTO;
import de.p2tools.p2lib.checkforactinfos.InfoAlert;
import de.p2tools.p2lib.tools.date.P2LDateFactory;
import de.p2tools.p2lib.tools.log.P2Log;
import java.util.ArrayList;
import javafx.application.Platform;

public class FoundAll {
    private FoundAll() {
    }

    public static void foundAll(FoundSearchDataDTO foundSearchDataDTO) {
        ArrayList<String> log = new ArrayList<String>();
        log.add("=====================================");
        log.add("Update-Suche: " + foundSearchDataDTO.searchUrlDownload);
        log.add("Letzte Suche war: " + foundSearchDataDTO.getLastFoundDate());
        P2Log.sysLog(log);
        try {
            FoundAllFiles.found(foundSearchDataDTO);
        }
        catch (Exception ex) {
            P2Log.errorLog(956201210, ex, "URL: " + foundSearchDataDTO.getSearchUrlDownload());
            Platform.runLater(() -> {
                if (foundSearchDataDTO.isShowDialogAlways()) {
                    P2Alert.showErrorAlert("Update-Suche", "Die Suche nach einem Programmupdate hat nicht geklappt.");
                }
            });
            return;
        }
        foundSearchDataDTO.setLastFoundDate(P2LDateFactory.toStringR(FoundAllFiles.maxFoundDate));
        if (foundSearchDataDTO.isShowDialogAlways() || foundSearchDataDTO.isFoundNewInfo() && !foundSearchDataDTO.getFoundFileListInfo().isEmpty() || foundSearchDataDTO.isFoundNewVersion() && !foundSearchDataDTO.getFoundFileListAct().isEmpty() || foundSearchDataDTO.isSearchBeta() && foundSearchDataDTO.isFoundNewBeta() && !foundSearchDataDTO.getFoundFileListBeta().isEmpty() || foundSearchDataDTO.isSearchBeta() && foundSearchDataDTO.isSearchDaily() && foundSearchDataDTO.isFoundNewDaily() && !foundSearchDataDTO.getFoundFileListDaily().isEmpty()) {
            Platform.runLater(() -> FoundAll.showInfoAlert(foundSearchDataDTO));
        } else {
            log.clear();
            log.add("gibt kein Update");
            log.add("=====================================");
            P2Log.sysLog(log);
        }
    }

    private static void showInfoAlert(FoundSearchDataDTO foundSearchDataDTO) {
        new InfoAlert(foundSearchDataDTO);
        if (foundSearchDataDTO.isSearchActAgain()) {
            foundSearchDataDTO.setLastFoundDate(foundSearchDataDTO.getProgBuildDate());
        }
    }
}

