/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.p2lib;

import de.p2tools.p2lib.P2LibConst;
import de.p2tools.p2lib.guitools.P2WindowIcon;
import de.p2tools.p2lib.mediathek.filter.Filter;
import java.util.ArrayList;
import java.util.Collection;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.scene.Scene;
import javafx.stage.Stage;

public class P2LibInit {
    private static final String PATH_CSS = "de/p2tools/p2lib/css/";

    public static void initLib(Stage stage, String progName, String userAgent, BooleanProperty darkMode, BooleanProperty blackWhite, BooleanProperty themeChanged, BooleanProperty regExOnlyCompare, String cssFile, String cssFileDark, IntegerProperty fontSize, String orgIcon, String ownIcon, boolean debug, boolean duration) {
        P2LibConst.primaryStage = stage;
        P2LibConst.actStage = stage;
        P2LibConst.progName = progName;
        P2LibConst.userAgent = userAgent;
        P2LibConst.darkMode = darkMode == null ? new SimpleBooleanProperty(false) : darkMode;
        P2LibConst.blackWhite = blackWhite == null ? new SimpleBooleanProperty(false) : blackWhite;
        P2LibConst.fontSize = fontSize == null ? new SimpleIntegerProperty(0) : fontSize;
        BooleanProperty booleanProperty = P2LibConst.themeChanged = themeChanged == null ? new SimpleBooleanProperty(false) : themeChanged;
        if (regExOnlyCompare != null) {
            regExOnlyCompare.addListener((u, o, n) -> {
                Filter.REG_EX_ONLY_CONTAIN = regExOnlyCompare.get();
            });
        }
        P2LibConst.cssFile = cssFile;
        P2LibConst.cssFileDark = cssFileDark;
        P2LibConst.debug = debug;
        P2LibConst.duration = duration;
        P2WindowIcon.setOrgIcon(orgIcon);
        P2WindowIcon.setStageIcon(ownIcon);
        P2LibConst.darkMode.addListener((u, o, n) -> {
            P2LibInit.addP2CssToScene(stage.getScene());
            P2LibConst.themeChanged.set(!P2LibConst.themeChanged.get());
        });
        P2LibConst.blackWhite.addListener((u, o, n) -> {
            P2LibInit.addP2CssToScene(stage.getScene());
            P2LibConst.themeChanged.set(!P2LibConst.themeChanged.get());
        });
        P2LibConst.fontSize.addListener((u, o, n) -> {
            P2LibInit.addP2CssToScene(stage.getScene());
            P2LibConst.themeChanged.set(!P2LibConst.themeChanged.get());
        });
    }

    public static void setActStage(Stage stage) {
        P2LibConst.actStage = stage;
    }

    public static void initProxy(boolean useProxy, String proxyHost, String proxyPort, String proxyUser, String proxyPwd) {
        P2LibConst.useProxy.setValue(useProxy);
        P2LibConst.proxyHost.setValue(proxyHost);
        P2LibConst.proxyPort.setValue(proxyPort);
        P2LibConst.proxyUser.setValue(proxyUser);
        P2LibConst.proxyPwd.setValue(proxyPwd);
    }

    public static void addP2CssToScene(Scene scene) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("de/p2tools/p2lib/css/p2Css_button.css");
        list.add("de/p2tools/p2lib/css/p2Css_maskerPane.css");
        list.add("de/p2tools/p2lib/css/p2Css_toggleSwitch.css");
        list.add("de/p2tools/p2lib/css/p2Css_p2Notify.css");
        list.add("de/p2tools/p2lib/css/p2Css_table.css");
        list.add("de/p2tools/p2lib/css/p2Css.css");
        list.add("de/p2tools/p2lib/css/p2Css_toolButton.css");
        list.add("de/p2tools/p2lib/css/p2Css_smallGui.css");
        list.add("de/p2tools/p2lib/css/p2Css_dialog.css");
        list.add("de/p2tools/p2lib/css/p2Css_gui.css");
        if (P2LibConst.darkMode.getValue().booleanValue()) {
            list.add("de/p2tools/p2lib/css/p2Css_dark.css");
            list.add("de/p2tools/p2lib/css/p2Css_darkTable.css");
        }
        if (P2LibConst.blackWhite.getValue().booleanValue()) {
            if (P2LibConst.darkMode.getValue().booleanValue()) {
                list.add("de/p2tools/p2lib/css/p2Css_bw_b.css");
            } else {
                list.add("de/p2tools/p2lib/css/p2Css_bw_w.css");
            }
        }
        list.add(P2LibConst.cssFile);
        if (P2LibConst.darkMode.getValue().booleanValue()) {
            list.add(P2LibConst.cssFileDark);
        }
        if (scene != null) {
            scene.getStylesheets().setAll((Collection<String>)list);
            scene.getRoot().setStyle("-fx-font-size: " + P2LibConst.fontSize.get() + " ;");
        }
    }
}

