/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.tools.table;

import de.p2tools.mtplayer.controller.config.ProgColorList;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.data.film.FilmDataMTP;
import javafx.beans.property.BooleanProperty;
import javafx.scene.Node;
import javafx.scene.control.TableRow;
import javafx.scene.control.Tooltip;

public class TableRowLiveFilm<T>
extends TableRow<T> {
    private final BooleanProperty geoMelden = ProgConfig.SYSTEM_MARK_GEO;

    @Override
    public void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        if (item == null || empty) {
            this.setStyle("");
            this.setTooltip(null);
        } else {
            FilmDataMTP film = (FilmDataMTP)item;
            if (ProgConfig.LIVE_FILM_GUI_SHOW_TABLE_TOOL_TIP.getValue().booleanValue()) {
                this.setTooltip(new Tooltip(film.getTheme() + "\n" + film.getTitle()));
            }
            if (film.isLive()) {
                for (int i = 0; i < this.getChildren().size(); ++i) {
                    ((Node)this.getChildren().get(i)).setStyle(ProgColorList.FILM_LIVESTREAM.getCssFontBold());
                }
            } else if (this.geoMelden.get() && film.isGeoBlocked()) {
                for (int i = 0; i < this.getChildren().size(); ++i) {
                    ((Node)this.getChildren().get(i)).setStyle(ProgColorList.FILM_GEOBLOCK.getCssFontBold());
                }
            } else if (film.isNewFilm()) {
                for (int i = 0; i < this.getChildren().size(); ++i) {
                    ((Node)this.getChildren().get(i)).setStyle(ProgColorList.FILM_NEW.getCssFont());
                }
            } else {
                for (int i = 0; i < this.getChildren().size(); ++i) {
                    ((Node)this.getChildren().get(i)).setStyle("");
                }
            }
            if (film.isBookmark()) {
                this.setStyle(ProgColorList.BOOKMARK.getCssBackground());
            } else if (film.isShown()) {
                this.setStyle(ProgColorList.FILM_HISTORY.getCssBackground());
            } else {
                this.setStyle("");
            }
        }
    }
}

