/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.tools.table;

import de.p2tools.mtplayer.controller.config.ProgColorList;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.data.film.FilmDataMTP;
import javafx.scene.control.TableRow;
import javafx.scene.control.Tooltip;

public class TableRowFilm<T>
extends TableRow<T> {
    @Override
    public void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        if (item == null || empty) {
            this.setStyle("");
            this.setTooltip(null);
        } else {
            FilmDataMTP film = (FilmDataMTP)item;
            if (ProgConfig.FILM_GUI_SHOW_TABLE_TOOL_TIP.getValue().booleanValue()) {
                this.setTooltip(new Tooltip(film.getTheme() + "\n" + film.getTitle()));
            }
            if (film.isBookmark()) {
                this.setStyle(ProgColorList.BOOKMARK.getCssBackground());
            } else if (film.isShown()) {
                this.setStyle(ProgColorList.FILM_HISTORY.getCssBackground());
            } else {
                this.setStyle("");
            }
        }
    }
}

