/*
 * Decompiled with CFR 0.152.
 */
package de.p2tools.mtplayer.gui.tools.table;

import de.p2tools.mtplayer.controller.config.ProgColorList;
import de.p2tools.mtplayer.controller.config.ProgConfig;
import de.p2tools.mtplayer.controller.data.download.DownloadData;
import javafx.beans.property.BooleanProperty;
import javafx.scene.Node;
import javafx.scene.control.TableRow;
import javafx.scene.control.Tooltip;

public class TableRowDownload<T>
extends TableRow<T> {
    private final BooleanProperty geoMelden = ProgConfig.SYSTEM_MARK_GEO;

    @Override
    public void updateItem(T item, boolean empty) {
        super.updateItem(item, empty);
        if (item == null || empty) {
            this.setStyle("");
            this.setTooltip(null);
        } else {
            DownloadData download = (DownloadData)item;
            if (ProgConfig.DOWNLOAD_GUI_SHOW_TABLE_TOOL_TIP.getValue().booleanValue()) {
                this.setTooltip(new Tooltip(download.getTheme() + "\n" + download.getTitle()));
            }
            if (this.geoMelden.get() && download.getGeoBlocked()) {
                for (int i = 0; i < this.getChildren().size(); ++i) {
                    ((Node)this.getChildren().get(i)).setStyle(ProgColorList.FILM_GEOBLOCK.getCssFontBold());
                }
            } else if (download.isStateError()) {
                Tooltip tooltip = new Tooltip();
                tooltip.setText(download.getErrorMessage());
                this.setTooltip(tooltip);
            } else {
                for (int i = 0; i < this.getChildren().size(); ++i) {
                    ((Node)this.getChildren().get(i)).setStyle("");
                }
            }
            switch (download.getState()) {
                case 0: 
                case 1: {
                    this.setStyle("");
                    break;
                }
                case 2: {
                    this.setStyle(ProgColorList.DOWNLOAD_WAIT.getCssBackground());
                    break;
                }
                case 3: {
                    this.setStyle(ProgColorList.DOWNLOAD_RUN.getCssBackground());
                    break;
                }
                case 4: {
                    this.setStyle(ProgColorList.DOWNLOAD_FINISHED.getCssBackground());
                    break;
                }
                case 5: {
                    this.setStyle(ProgColorList.DOWNLOAD_ERROR.getCssBackground());
                }
            }
        }
    }
}

